/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.show;

import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.column.show.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1046})
public class ShowColumnsAnalyzer
extends BaseSemanticAnalyzer {
    public ShowColumnsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 4 || root.getChildCount() < 1) {
            throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg(root.toStringTree()));
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String tableName = ShowColumnsAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        String pattern = null;
        switch (root.getChildCount()) {
            case 1: {
                break;
            }
            case 2: {
                pattern = ShowColumnsAnalyzer.unescapeSQLString(root.getChild(1).getText());
                break;
            }
            case 3: {
                if (tableName.contains(".")) {
                    throw new SemanticException("Duplicates declaration for database name");
                }
                tableName = ShowColumnsAnalyzer.getUnescapedName((ASTNode)root.getChild(2)) + "." + tableName;
                break;
            }
            case 4: {
                if (tableName.contains(".")) {
                    throw new SemanticException("Duplicates declaration for database name");
                }
                tableName = ShowColumnsAnalyzer.getUnescapedName((ASTNode)root.getChild(2)) + "." + tableName;
                pattern = ShowColumnsAnalyzer.unescapeSQLString(root.getChild(3).getText());
                break;
            }
        }
        Table table = this.getTable(tableName);
        this.inputs.add(new ReadEntity(table));
        ShowColumnsDesc desc = new ShowColumnsDesc(this.ctx.getResFile(), tableName, pattern);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("Field#string"));
    }
}

