/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.add;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.column.add.AlterTableAddColumnsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;

public class AlterTableAddColumnsOperation
extends AbstractAlterTableOperation<AlterTableAddColumnsDesc> {
    public AlterTableAddColumnsOperation(DDLOperationContext context, AlterTableAddColumnsDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        String serializationLib = sd.getSerdeInfo().getSerializationLib();
        AvroSerdeUtils.handleAlterTableForAvro(this.context.getConf(), serializationLib, table.getTTable().getParameters());
        List<FieldSchema> oldColumns = partition == null ? table.getColsForMetastore() : partition.getColsForMetastore();
        List<FieldSchema> newColumns = ((AlterTableAddColumnsDesc)this.desc).getNewColumns();
        if ("org.apache.hadoop.hive.serde.thrift.columnsetSerDe".equals(serializationLib)) {
            this.context.getConsole().printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
            sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            sd.setCols(newColumns);
        } else {
            for (FieldSchema newColumn : newColumns) {
                for (FieldSchema oldColumn : oldColumns) {
                    if (!oldColumn.getName().equalsIgnoreCase(newColumn.getName())) continue;
                    throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, newColumn.getName());
                }
                oldColumns.add(newColumn);
            }
            sd.setCols(oldColumns);
        }
    }
}

