/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableWithConstraintsDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.constraint.add.AlterTableAddConstraintOperation;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;

public abstract class AbstractAlterTableOperation<T extends AbstractAlterTableDesc>
extends DDLOperation<T> {
    protected EnvironmentContext environmentContext;

    public AbstractAlterTableOperation(DDLOperationContext context, T desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (!AlterTableUtils.allowOperationInReplicationScope(this.context.getDb(), ((AbstractAlterTableDesc)this.desc).getDbTableName(), null, ((AbstractAlterTableDesc)this.desc).getReplicationSpec())) {
            LOG.debug("DDLTask: Alter Table is skipped as table {} is newer than update", (Object)((AbstractAlterTableDesc)this.desc).getDbTableName());
            return 0;
        }
        Table oldTable = this.context.getDb().getTable(((AbstractAlterTableDesc)this.desc).getDbTableName());
        List<Partition> partitions = this.getPartitions(oldTable, ((AbstractAlterTableDesc)this.desc).getPartitionSpec(), this.context);
        Table table = oldTable.copy();
        this.environmentContext = this.initializeEnvironmentContext(((AbstractAlterTableDesc)this.desc).getEnvironmentContext());
        if (partitions == null) {
            this.doAlteration(table, null);
        } else {
            for (Partition partition : partitions) {
                this.doAlteration(table, partition);
            }
        }
        this.finalizeAlterTableWithWriteIdOp(table, oldTable, partitions, this.context, this.environmentContext, (AbstractAlterTableDesc)this.desc);
        return 0;
    }

    private List<Partition> getPartitions(Table tbl, Map<String, String> partSpec, DDLOperationContext context) throws HiveException {
        List<Object> partitions = null;
        if (partSpec != null) {
            if (AlterTableUtils.isFullPartitionSpec(tbl, partSpec)) {
                partitions = new ArrayList();
                Partition part = context.getDb().getPartition(tbl, partSpec, false);
                if (part == null) {
                    throw new HiveException(ErrorMsg.INVALID_PARTITION, StringUtils.join(partSpec.keySet(), ',') + " for table " + tbl.getTableName());
                }
                partitions.add(part);
            } else {
                partitions = context.getDb().getPartitions(tbl, partSpec);
            }
        }
        return partitions;
    }

    private EnvironmentContext initializeEnvironmentContext(EnvironmentContext environmentContext) {
        EnvironmentContext result;
        EnvironmentContext environmentContext2 = result = environmentContext == null ? new EnvironmentContext() : environmentContext;
        if (result.getProperties() == null || result.getProperties().get("DO_NOT_UPDATE_STATS") == null) {
            result.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        return result;
    }

    protected abstract void doAlteration(Table var1, Partition var2) throws HiveException;

    protected StorageDescriptor getStorageDescriptor(Table tbl, Partition part) {
        return part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
    }

    private void finalizeAlterTableWithWriteIdOp(Table table, Table oldTable, List<Partition> partitions, DDLOperationContext context, EnvironmentContext environmentContext, AbstractAlterTableDesc alterTable) throws HiveException {
        if (partitions == null) {
            AbstractAlterTableOperation.updateModifiedParameters(table.getTTable().getParameters(), context.getConf());
            table.checkValidity(context.getConf());
        } else {
            for (Partition partition : partitions) {
                AbstractAlterTableOperation.updateModifiedParameters(partition.getParameters(), context.getConf());
            }
        }
        try {
            environmentContext.putToProperties("alterTableOpType", alterTable.getType().name());
            if (partitions == null) {
                long writeId;
                long l = writeId = ((AbstractAlterTableDesc)this.desc).getWriteId() != null ? ((AbstractAlterTableDesc)this.desc).getWriteId() : 0L;
                if (((AbstractAlterTableDesc)this.desc).getReplicationSpec() != null && ((AbstractAlterTableDesc)this.desc).getReplicationSpec().isMigratingToTxnTable()) {
                    Long tmpWriteId = ReplUtils.getMigrationCurrentTblWriteId(context.getConf());
                    if (tmpWriteId == null) {
                        throw new HiveException("DDLTask : Write id is not set in the config by open txn task for migration");
                    }
                    writeId = tmpWriteId;
                }
                context.getDb().alterTable(alterTable.getDbTableName(), table, alterTable.isCascade(), environmentContext, true, writeId);
            } else {
                boolean isTxn = false;
                if (((AbstractAlterTableDesc)this.desc).getPartitionSpec() != null && ((AbstractAlterTableDesc)this.desc).getType() == AlterTableType.ADDPROPS) {
                    Map<String, String> props = ((AbstractAlterTableDesc)this.desc).getProps();
                    isTxn = ((AbstractAlterTableDesc)this.desc).getReplicationSpec() != null && ((AbstractAlterTableDesc)this.desc).getReplicationSpec().isInReplicationScope() ? props.get("COLUMN_STATS_ACCURATE") != null : true;
                }
                context.getDb().alterPartitions(Warehouse.getQualifiedName(table.getTTable()), partitions, environmentContext, isTxn);
            }
            if (alterTable instanceof AbstractAlterTableWithConstraintsDesc) {
                AlterTableAddConstraintOperation.addConstraints((AbstractAlterTableWithConstraintsDesc)alterTable, context.getDb());
            }
        }
        catch (InvalidOperationException e) {
            LOG.error("alter table: ", (Throwable)e);
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        if (partitions != null) {
            for (Partition partition : partitions) {
                context.getWork().getInputs().add(new ReadEntity(partition));
                DDLUtils.addIfAbsentByName(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK), context);
            }
        } else {
            context.getWork().getInputs().add(new ReadEntity(oldTable));
            DDLUtils.addIfAbsentByName(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK), context);
        }
    }

    private static void updateModifiedParameters(Map<String, String> params, HiveConf conf) throws HiveException {
        String user = SessionState.getUserFromAuthenticator();
        params.put("last_modified_by", user);
        params.put("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
    }
}

