/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.msck;

import java.io.IOException;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.Msck;
import org.apache.hadoop.hive.metastore.MsckInfo;
import org.apache.hadoop.hive.metastore.PartitionManagementTask;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.misc.msck.MsckDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.thrift.TException;

public class MsckOperation
extends DDLOperation<MsckDesc> {
    public MsckOperation(DDLOperationContext context, MsckDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException, TException {
        try {
            Msck msck = new Msck(false, false);
            msck.init(this.context.getDb().getConf());
            String[] names = Utilities.getDbTableName(((MsckDesc)this.desc).getTableName());
            long partitionExpirySeconds = -1L;
            try (HiveMetaStoreClient msc = new HiveMetaStoreClient(this.context.getConf());){
                Table table = msc.getTable("hive", names[0], names[1]);
                String qualifiedTableName = Warehouse.getCatalogQualifiedTableName(table);
                boolean msckEnablePartitionRetention = MetastoreConf.getBoolVar(this.context.getConf(), MetastoreConf.ConfVars.MSCK_REPAIR_ENABLE_PARTITION_RETENTION);
                if (msckEnablePartitionRetention) {
                    partitionExpirySeconds = PartitionManagementTask.getRetentionPeriodInSeconds(table);
                    LOG.info("{} - Retention period ({}s) for partition is enabled for MSCK REPAIR..", (Object)qualifiedTableName, (Object)partitionExpirySeconds);
                }
            }
            MsckInfo msckInfo = new MsckInfo("hive", names[0], names[1], ((MsckDesc)this.desc).getPartitionsSpecs(), ((MsckDesc)this.desc).getResFile(), ((MsckDesc)this.desc).isRepairPartitions(), ((MsckDesc)this.desc).isAddPartitions(), ((MsckDesc)this.desc).isDropPartitions(), partitionExpirySeconds);
            return msck.repair(msckInfo);
        }
        catch (MetaException e) {
            LOG.error("Unable to create msck instance.", (Throwable)e);
            return 1;
        }
        catch (SemanticException e) {
            LOG.error("Msck failed.", (Throwable)e);
            return 1;
        }
    }
}

