/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.msck;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.AbstractFunctionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.misc.msck.MsckDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={944})
public class MsckAnalyzer
extends AbstractFunctionAnalyzer {
    public MsckAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() == 0) {
            throw new SemanticException("MSCK command must have arguments");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        boolean repair = root.getChild(0).getType() == 267;
        int offset = repair ? 1 : 0;
        String tableName = MsckAnalyzer.getUnescapedName((ASTNode)root.getChild(0 + offset));
        boolean addPartitions = true;
        boolean dropPartitions = false;
        if (root.getChildCount() > 1 + offset) {
            addPartitions = this.isMsckAddPartition(root.getChild(1 + offset).getType());
            dropPartitions = this.isMsckDropPartition(root.getChild(1 + offset).getType());
        }
        Table table = this.getTable(tableName);
        List<Map<String, String>> specs = this.getPartitionSpecs(table, root);
        if (repair && AcidUtils.isTransactionalTable(table)) {
            this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_EXCLUSIVE));
        } else {
            this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_SHARED));
        }
        MsckDesc desc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair, addPartitions, dropPartitions);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private boolean isMsckAddPartition(int type) {
        return type == 312 || type == 29;
    }

    private boolean isMsckDropPartition(int type) {
        return type == 312 || type == 114;
    }
}

