/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.create;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.function.create.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;

public class CreateFunctionOperation
extends DDLOperation<CreateFunctionDesc> {
    public CreateFunctionOperation(DDLOperationContext context, CreateFunctionDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (((CreateFunctionDesc)this.desc).isTemp()) {
            return this.createTemporaryFunction();
        }
        try {
            return this.createPermanentFunction();
        }
        catch (Exception e) {
            return this.handlePermanentFunctionCreationException(e);
        }
    }

    private int createTemporaryFunction() {
        try {
            FunctionInfo.FunctionResource[] resources = FunctionUtils.toFunctionResource(((CreateFunctionDesc)this.desc).getResources());
            FunctionUtils.addFunctionResources(resources);
            Class<?> udfClass = this.getUdfClass();
            FunctionInfo registered = FunctionRegistry.registerTemporaryUDF(((CreateFunctionDesc)this.desc).getName(), udfClass, resources);
            if (registered != null) {
                return 0;
            }
            this.context.getConsole().printError("FAILED: Class " + ((CreateFunctionDesc)this.desc).getClassName() + " does not implement UDF, GenericUDF, or UDAF");
            return 1;
        }
        catch (HiveException e) {
            this.context.getConsole().printError("FAILED: " + e.toString());
            LOG.info("create function: ", (Throwable)e);
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.context.getConsole().printError("FAILED: Class " + ((CreateFunctionDesc)this.desc).getClassName() + " not found");
            LOG.info("create function: ", (Throwable)e);
            return 1;
        }
    }

    private Class<?> getUdfClass() throws ClassNotFoundException {
        ClassLoader classLoader = Utilities.getSessionSpecifiedClassLoader();
        return Class.forName(((CreateFunctionDesc)this.desc).getClassName(), true, classLoader);
    }

    private int createPermanentFunction() throws HiveException, IOException {
        String functionName;
        String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(((CreateFunctionDesc)this.desc).getName());
        String dbName = qualifiedNameParts[0];
        if (this.skipIfNewerThenUpdate(dbName, functionName = qualifiedNameParts[1])) {
            return 0;
        }
        this.checkLocalFunctionResources();
        String registeredName = FunctionUtils.qualifyFunctionName(functionName, dbName);
        boolean registrationSuccess = this.registerFunction(registeredName);
        if (!registrationSuccess) {
            this.context.getConsole().printError("Failed to register " + registeredName + " using class " + ((CreateFunctionDesc)this.desc).getClassName());
            return 1;
        }
        boolean addToMetastoreSuccess = this.addToMetastore(dbName, functionName, registeredName);
        if (!addToMetastoreSuccess) {
            return 1;
        }
        return 0;
    }

    private boolean skipIfNewerThenUpdate(String dbName, String functionName) throws HiveException {
        if (((CreateFunctionDesc)this.desc).getReplicationSpec().isInReplicationScope()) {
            Map<String, String> dbProps = Hive.get().getDatabase(dbName).getParameters();
            if (!((CreateFunctionDesc)this.desc).getReplicationSpec().allowEventReplacementInto(dbProps)) {
                LOG.debug("FunctionTask: Create Function {} is skipped as database {} is newer than update", (Object)functionName, (Object)dbName);
                return true;
            }
        }
        return false;
    }

    private void checkLocalFunctionResources() throws HiveException {
        if (CollectionUtils.isNotEmpty(((CreateFunctionDesc)this.desc).getResources())) {
            try {
                String localFsScheme = FileSystem.getLocal((Configuration)this.context.getDb().getConf()).getUri().getScheme();
                String configuredFsScheme = FileSystem.get((Configuration)this.context.getDb().getConf()).getUri().getScheme();
                if (configuredFsScheme.equals(localFsScheme)) {
                    return;
                }
                for (ResourceUri res : ((CreateFunctionDesc)this.desc).getResources()) {
                    String resUri = res.getUri();
                    if (!ResourceDownloader.isFileUri(resUri)) continue;
                    throw new HiveException("Hive warehouse is non-local, but " + res.getUri() + " specifies file on local " + "filesystem. Resources on non-local warehouse should specify a non-local scheme/path");
                }
            }
            catch (HiveException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Exception caught in checkLocalFunctionResources", (Throwable)e);
                throw new HiveException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerFunction(String registeredName) throws SemanticException, HiveException {
        FunctionInfo registered = null;
        HiveConf oldConf = SessionState.get().getConf();
        try {
            SessionState.get().setConf(this.context.getConf());
            registered = FunctionRegistry.registerPermanentFunction(registeredName, ((CreateFunctionDesc)this.desc).getClassName(), true, FunctionUtils.toFunctionResource(((CreateFunctionDesc)this.desc).getResources()));
        }
        catch (RuntimeException ex) {
            Throwable t = ex;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            this.context.getTask().setException(t);
        }
        finally {
            SessionState.get().setConf(oldConf);
        }
        return registered != null;
    }

    private boolean addToMetastore(String dbName, String functionName, String registeredName) throws HiveException {
        try {
            Function function = new Function(functionName, dbName, ((CreateFunctionDesc)this.desc).getClassName(), SessionState.get().getUserName(), PrincipalType.USER, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, ((CreateFunctionDesc)this.desc).getResources());
            this.context.getDb().createFunction(function);
            return true;
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof AlreadyExistsException)) {
                FunctionRegistry.unregisterPermanentFunction(registeredName);
            }
            this.context.getTask().setException(e);
            LOG.error("Failed to add function " + ((CreateFunctionDesc)this.desc).getName() + " to the metastore.", (Throwable)e);
            return false;
        }
    }

    private int handlePermanentFunctionCreationException(Exception e) {
        if (((CreateFunctionDesc)this.desc).getReplicationSpec().isInReplicationScope() && e.getCause() instanceof AlreadyExistsException) {
            LOG.info("Create function is idempotent as function: " + ((CreateFunctionDesc)this.desc).getName() + " already exists.");
            return 0;
        }
        this.context.getTask().setException(e);
        LOG.error("Failed to create function", (Throwable)e);
        return 1;
    }
}

