/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.create;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.AbstractFunctionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.function.create.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DDLSemanticAnalyzerFactory.DDLType(types={822})
public class CreateFunctionAnalyzer
extends AbstractFunctionAnalyzer {
    private static final Logger SESSION_STATE_LOG = LoggerFactory.getLogger((String)"SessionState");
    private static final Map<Integer, ResourceType> TOKEN_TYPE_TO_RESOURCE_TYPE = ImmutableMap.of(925, ResourceType.JAR, 884, ResourceType.FILE, 806, ResourceType.ARCHIVE);

    public CreateFunctionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean isTemporary;
        String functionName = root.getChild(0).getText().toLowerCase();
        boolean bl = isTemporary = root.getFirstChildWithType(1121) != null;
        if (isTemporary && FunctionUtils.isQualifiedFunctionName(functionName)) {
            throw new SemanticException("Temporary function cannot be created with a qualified name.");
        }
        String className = CreateFunctionAnalyzer.unescapeSQLString(root.getChild(1).getText());
        List<ResourceUri> resources = this.getResourceList(root);
        if (!isTemporary && resources == null) {
            SESSION_STATE_LOG.warn("permanent functions created without USING  clause will not be replicated.");
        }
        CreateFunctionDesc desc = new CreateFunctionDesc(functionName, className, isTemporary, resources, null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.addEntities(functionName, className, isTemporary, resources);
    }

    private List<ResourceUri> getResourceList(ASTNode ast) throws SemanticException {
        ArrayList<ResourceUri> resources = null;
        ASTNode resourcesNode = (ASTNode)ast.getFirstChildWithType(1021);
        if (resourcesNode != null) {
            resources = new ArrayList<ResourceUri>();
            for (int idx = 0; idx < resourcesNode.getChildCount(); ++idx) {
                ASTNode node = (ASTNode)resourcesNode.getChild(idx);
                if (node.getToken().getType() != 1022) {
                    throw new SemanticException("Expected token type TOK_RESOURCE_URI but found " + node.getToken().toString());
                }
                if (node.getChildCount() != 2) {
                    throw new SemanticException("Expected 2 child nodes of TOK_RESOURCE_URI but found " + node.getChildCount());
                }
                ASTNode resourceTypeNode = (ASTNode)node.getChild(0);
                ASTNode resourceUriNode = (ASTNode)node.getChild(1);
                ResourceType resourceType = TOKEN_TYPE_TO_RESOURCE_TYPE.get(resourceTypeNode.getType());
                if (resourceType == null) {
                    throw new SemanticException("Unexpected token " + resourceTypeNode);
                }
                resources.add(new ResourceUri(resourceType, PlanUtils.stripQuotes(resourceUriNode.getText())));
            }
        }
        return resources;
    }
}

