/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.use;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.database.use.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SwitchDatabaseOperation
extends DDLOperation<SwitchDatabaseDesc> {
    public SwitchDatabaseOperation(DDLOperationContext context, SwitchDatabaseDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String dbName = ((SwitchDatabaseDesc)this.desc).getDatabaseName();
        if (!this.context.getDb().databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        SessionState.get().setCurrentDatabase(dbName);
        Database database = this.context.getDb().getDatabase(dbName);
        assert (database != null);
        Map<String, String> dbParams = database.getParameters();
        if (dbParams != null) {
            for (HiveConf.ConfVars var : HiveConf.dbVars) {
                String newValue = dbParams.get(var.varname);
                if (newValue == null) continue;
                LOG.info("Changing {} from {} to {}", new Object[]{var.varname, this.context.getConf().getVar(var), newValue});
                this.context.getConf().setVar(var, newValue);
            }
        }
        return 0;
    }
}

