/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.showcreate;

import java.io.Closeable;
import java.io.DataOutputStream;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.database.showcreate.ShowCreateDatabaseDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.common.util.HiveStringUtils;

public class ShowCreateDatabaseOperation
extends DDLOperation<ShowCreateDatabaseDesc> {
    public ShowCreateDatabaseOperation(DDLOperationContext context, ShowCreateDatabaseDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        DataOutputStream outStream = DDLUtils.getOutputStream(((ShowCreateDatabaseDesc)this.desc).getResFile(), this.context);
        try {
            int n = this.showCreateDatabase(outStream);
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
    }

    private int showCreateDatabase(DataOutputStream outStream) throws Exception {
        Database database = this.context.getDb().getDatabase(((ShowCreateDatabaseDesc)this.desc).getDatabaseName());
        StringBuilder createDbCommand = new StringBuilder();
        createDbCommand.append("CREATE DATABASE `").append(database.getName()).append("`\n");
        if (database.getDescription() != null) {
            createDbCommand.append("COMMENT\n  '");
            createDbCommand.append(HiveStringUtils.escapeHiveCommand(database.getDescription())).append("'\n");
        }
        createDbCommand.append("LOCATION\n  '");
        createDbCommand.append(database.getLocationUri()).append("'\n");
        String propertiesToString = DDLUtils.propertiesToString(database.getParameters(), null);
        if (!propertiesToString.isEmpty()) {
            createDbCommand.append("WITH DBPROPERTIES (\n");
            createDbCommand.append(propertiesToString).append(")\n");
        }
        outStream.write(createDbCommand.toString().getBytes("UTF-8"));
        return 0;
    }
}

