/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.create;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.database.create.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class CreateDatabaseOperation
extends DDLOperation<CreateDatabaseDesc> {
    private static final String DATABASE_PATH_SUFFIX = ".db";

    public CreateDatabaseOperation(DDLOperationContext context, CreateDatabaseDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Database database = new Database();
        database.setName(((CreateDatabaseDesc)this.desc).getName());
        database.setDescription(((CreateDatabaseDesc)this.desc).getComment());
        database.setLocationUri(((CreateDatabaseDesc)this.desc).getLocationUri());
        database.setParameters(((CreateDatabaseDesc)this.desc).getDatabaseProperties());
        database.setOwnerName(SessionState.getUserFromAuthenticator());
        database.setOwnerType(PrincipalType.USER);
        try {
            this.makeLocationQualified(database);
            this.context.getDb().createDatabase(database, ((CreateDatabaseDesc)this.desc).getIfNotExists());
        }
        catch (AlreadyExistsException ex) {
            throw new HiveException((Throwable)ex, ErrorMsg.DATABASE_ALREADY_EXISTS, ((CreateDatabaseDesc)this.desc).getName());
        }
        return 0;
    }

    private void makeLocationQualified(Database database) throws HiveException {
        if (database.isSetLocationUri()) {
            database.setLocationUri(Utilities.getQualifiedPath(this.context.getConf(), new Path(database.getLocationUri())));
        } else {
            Path path = new Path(MetastoreConf.getVar(this.context.getConf(), MetastoreConf.ConfVars.WAREHOUSE), database.getName().toLowerCase() + DATABASE_PATH_SUFFIX);
            String qualifiedPath = Utilities.getQualifiedPath(this.context.getConf(), path);
            database.setLocationUri(qualifiedPath);
        }
    }
}

