/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.create;

import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.create.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={821})
public class CreateDatabaseAnalyzer
extends BaseSemanticAnalyzer {
    public CreateDatabaseAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = CreateDatabaseAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        boolean ifNotExists = false;
        String comment = null;
        String locationUri = null;
        Map<String, String> props = null;
        block6: for (int i = 1; i < root.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)root.getChild(i);
            switch (childNode.getToken().getType()) {
                case 905: {
                    ifNotExists = true;
                    continue block6;
                }
                case 837: {
                    comment = CreateDatabaseAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                case 839: {
                    props = CreateDatabaseAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block6;
                }
                case 838: {
                    locationUri = CreateDatabaseAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    this.outputs.add(this.toWriteEntity(locationUri));
                    continue block6;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        CreateDatabaseDesc desc = new CreateDatabaseDesc(databaseName, comment, locationUri, ifNotExists, props);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        Database database = new Database(databaseName, comment, locationUri, props);
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
    }
}

