/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.IOException;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverUtils {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);

    private DriverUtils() {
        throw new UnsupportedOperationException("DriverUtils should not be instantiated!");
    }

    public static void runOnDriver(HiveConf conf, String user, SessionState sessionState, String query) throws HiveException {
        DriverUtils.runOnDriver(conf, user, sessionState, query, null, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnDriver(HiveConf conf, String user, SessionState sessionState, String query, ValidWriteIdList writeIds, long compactorTxnId) throws HiveException {
        if (writeIds != null && compactorTxnId < 0L) {
            throw new IllegalArgumentException(JavaUtils.txnIdToString(compactorTxnId) + " is not valid. Context: " + query);
        }
        SessionState.setCurrentSessionState(sessionState);
        boolean isOk = false;
        try {
            QueryState qs = new QueryState.Builder().withHiveConf(conf).withGenerateNewQueryId(true).nonIsolated().build();
            Driver driver = new Driver(qs, user, null, null, writeIds, compactorTxnId);
            try {
                try {
                    driver.run(query);
                }
                catch (CommandProcessorException e) {
                    LOG.error("Failed to run " + query, (Throwable)e);
                    throw new HiveException("Failed to run " + query, e);
                }
            }
            finally {
                driver.close();
                driver.destroy();
            }
            isOk = true;
        }
        finally {
            if (!isOk) {
                try {
                    sessionState.close();
                }
                catch (Throwable th) {
                    LOG.warn("Failed to close a bad session", th);
                    SessionState.detachSession();
                }
            }
        }
    }

    public static SessionState setUpSessionState(HiveConf conf, String user, boolean doStart) {
        SessionState sessionState = SessionState.get();
        if (sessionState == null) {
            sessionState = new SessionState(conf, user);
            if (doStart) {
                sessionState.setIsHiveServerQuery(true);
                SessionState.start(sessionState);
            }
            SessionState.setCurrentSessionState(sessionState);
        }
        return sessionState;
    }

    public static void checkInterrupted(DriverState driverState, DriverContext driverContext, String msg, HookContext hookContext, PerfLogger perfLogger) throws CommandProcessorException {
        if (driverState.isAborted()) {
            String errorMessage = "FAILED: command has been interrupted: " + msg;
            CONSOLE.printError(errorMessage);
            if (hookContext != null) {
                try {
                    DriverUtils.invokeFailureHooks(driverContext, perfLogger, hookContext, errorMessage, null);
                }
                catch (Exception e) {
                    LOG.warn("Caught exception attempting to invoke Failure Hooks", (Throwable)e);
                }
            }
            throw DriverUtils.createProcessorException(driverContext, 1000, errorMessage, "HY008", null);
        }
    }

    public static void invokeFailureHooks(DriverContext driverContext, PerfLogger perfLogger, HookContext hookContext, String errorMessage, Throwable exception) throws Exception {
        hookContext.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
        hookContext.setErrorMessage(errorMessage);
        hookContext.setException(exception);
        driverContext.getHookRunner().runFailureHooks(hookContext);
    }

    public static CommandProcessorException createProcessorException(DriverContext driverContext, int ret, String errorMessage, String sqlState, Throwable downstreamError) {
        ErrorMsg em;
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
        driverContext.getQueryDisplay().setErrorMessage(errorMessage);
        if (downstreamError != null && downstreamError instanceof HiveException && (em = ((HiveException)downstreamError).getCanonicalErrorMsg()) != null) {
            return new CommandProcessorException(ret, em.getErrorCode(), errorMessage, sqlState, downstreamError);
        }
        return new CommandProcessorException(ret, -1, errorMessage, sqlState, downstreamError);
    }

    public static boolean checkConcurrency(DriverContext driverContext) {
        return driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
    }

    public static String getUserFromUGI(DriverContext driverContext) throws CommandProcessorException {
        try {
            return driverContext.getConf().getUser();
        }
        catch (IOException e) {
            String errorMessage = "FAILED: Error in determining user while acquiring locks: " + e.getMessage();
            CONSOLE.printError(errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
            throw DriverUtils.createProcessorException(driverContext, 10, errorMessage, ErrorMsg.findSQLState(e.getMessage()), e);
        }
    }
}

