/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContextImpl;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.security.authorization.command.CommandAuthorizer;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compiler {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private final Context context;
    private final DriverContext driverContext;
    private final DriverState driverState;
    private final PerfLogger perfLogger = SessionState.getPerfLogger(true);
    private ASTNode tree;

    public Compiler(Context context, DriverContext driverContext, DriverState driverState) {
        this.context = context;
        this.driverContext = driverContext;
        this.driverState = driverState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryPlan compile(String rawCommand, boolean deferClose) throws CommandProcessorException {
        this.initialize(rawCommand);
        boolean compileError = false;
        boolean parsed = false;
        QueryPlan plan = null;
        try {
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "before parsing and analysing the query", null, null);
            this.parse();
            parsed = true;
            BaseSemanticAnalyzer sem = this.analyze();
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "after analyzing query.", null, null);
            plan = this.createPlan(sem);
            this.authorize(sem);
            this.explainOutput(sem, plan);
        }
        catch (CommandProcessorException cpe) {
            compileError = true;
            throw cpe;
        }
        catch (Exception e) {
            compileError = true;
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "during query compilation: " + e.getMessage(), null, null);
            this.handleException(e);
        }
        finally {
            this.cleanUp(compileError, parsed, deferClose);
        }
        return plan;
    }

    private void initialize(String rawCommand) throws CommandProcessorException {
        String command;
        this.perfLogger.PerfLogBegin(CLASS_NAME, "Driver.run");
        this.perfLogger.PerfLogBegin(CLASS_NAME, "compile");
        this.driverState.compilingWithLocking();
        VariableSubstitution variableSubstitution = new VariableSubstitution(new HiveVariableSource(){

            @Override
            public Map<String, String> getHiveVariable() {
                return SessionState.get().getHiveVariables();
            }
        });
        String queryStr = command = variableSubstitution.substitute(this.driverContext.getConf(), rawCommand);
        try {
            queryStr = HookUtils.redactLogString(this.driverContext.getConf(), command);
        }
        catch (Exception e) {
            LOG.warn("WARNING! Query command could not be redacted." + e);
        }
        DriverUtils.checkInterrupted(this.driverState, this.driverContext, "at beginning of compilation.", null, null);
        this.context.setCmd(command);
        this.driverContext.getQueryDisplay().setQueryStr(queryStr);
        LOG.info("Compiling command(queryId=" + this.driverContext.getQueryId() + "): " + queryStr);
        this.driverContext.getConf().setQueryString(queryStr);
        if (SessionState.get() != null) {
            SessionState.get().getConf().setQueryString(queryStr);
            SessionState.get().setupQueryCurrentTimestamp();
        }
    }

    private void parse() throws ParseException {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "parse");
        this.driverContext.getHookRunner().runBeforeParseHook(this.context.getCmd());
        boolean success = false;
        try {
            this.tree = ParseUtils.parse(this.context.getCmd(), this.context);
            success = true;
            this.driverContext.getHookRunner().runAfterParseHook(this.context.getCmd(), !success);
        }
        catch (Throwable throwable) {
            this.driverContext.getHookRunner().runAfterParseHook(this.context.getCmd(), !success);
            throw throwable;
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "parse");
    }

    private BaseSemanticAnalyzer analyze() throws Exception {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "semanticAnalyze");
        this.driverContext.getHookRunner().runBeforeCompileHook(this.context.getCmd());
        SessionState.get().getCurrentFunctionsInUse().clear();
        Hive.get().getMSC().flushCache();
        this.driverContext.setBackupContext(new Context(this.context));
        boolean executeHooks = this.driverContext.getHookRunner().hasPreAnalyzeHooks();
        HiveSemanticAnalyzerHookContextImpl hookCtx = new HiveSemanticAnalyzerHookContextImpl();
        if (executeHooks) {
            hookCtx.setConf(this.driverContext.getConf());
            hookCtx.setUserName(this.driverContext.getUserName());
            hookCtx.setIpAddress(SessionState.get().getUserIpAddress());
            hookCtx.setCommand(this.context.getCmd());
            hookCtx.setHiveOperation(this.driverContext.getQueryState().getHiveOperation());
            this.tree = this.driverContext.getHookRunner().runPreAnalyzeHooks(hookCtx, this.tree);
        }
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.driverContext.getQueryState(), this.tree);
        if (!this.driverContext.isRetrial()) {
            if (this.driverContext.getQueryState().getHiveOperation() != null && this.driverContext.getQueryState().getHiveOperation().equals((Object)HiveOperation.REPLDUMP)) {
                this.setLastReplIdForDump(this.driverContext.getQueryState().getConf());
            }
            this.driverContext.setTxnType(AcidUtils.getTxnType(this.driverContext.getConf(), this.tree));
            this.openTransaction(this.driverContext.getTxnType());
            this.generateValidTxnList();
        }
        sem.analyze(this.tree, this.context);
        if (executeHooks) {
            hookCtx.update(sem);
            this.driverContext.getHookRunner().runPostAnalyzeHooks(hookCtx, sem.getAllRootTasks());
        }
        LOG.info("Semantic Analysis Completed (retrial = {})", (Object)this.driverContext.isRetrial());
        if (this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED)) {
            this.driverContext.setCacheUsage(sem.getCacheUsage());
        }
        sem.validate();
        this.perfLogger.PerfLogEnd(CLASS_NAME, "semanticAnalyze");
        return sem;
    }

    private void setLastReplIdForDump(HiveConf conf) throws HiveException, TException {
        Hive hiveDb = Hive.get();
        Long lastReplId = hiveDb.getMSC().getCurrentNotificationEventId().getEventId();
        conf.setLong("hive.repl.last.repl.id", lastReplId);
        LOG.debug("Setting hive.repl.last.repl.id = " + lastReplId);
    }

    private void openTransaction(TxnType txnType) throws LockException, CommandProcessorException {
        if (DriverUtils.checkConcurrency(this.driverContext) && this.startImplicitTxn(this.driverContext.getTxnManager()) && !this.driverContext.getTxnManager().isTxnOpen()) {
            String userFromUGI = DriverUtils.getUserFromUGI(this.driverContext);
            this.driverContext.getTxnManager().openTxn(this.context, userFromUGI, txnType);
        }
    }

    private boolean startImplicitTxn(HiveTxnManager txnManager) throws LockException {
        HiveOperation hiveOperation = this.driverContext.getQueryState().getHiveOperation();
        switch (hiveOperation == null ? HiveOperation.QUERY : hiveOperation) {
            case COMMIT: 
            case ROLLBACK: {
                if (!txnManager.isTxnOpen()) {
                    throw new LockException(null, ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN, hiveOperation.getOperationName());
                }
            }
            case SWITCHDATABASE: 
            case SET_AUTOCOMMIT: 
            case SHOWDATABASES: 
            case SHOWTABLES: 
            case SHOWCOLUMNS: 
            case SHOWFUNCTIONS: 
            case SHOWPARTITIONS: 
            case SHOWLOCKS: 
            case SHOWVIEWS: 
            case SHOW_ROLES: 
            case SHOW_ROLE_PRINCIPALS: 
            case SHOW_COMPACTIONS: 
            case SHOW_TRANSACTIONS: 
            case ABORT_TRANSACTIONS: 
            case KILL_QUERY: {
                return false;
            }
        }
        return !this.context.isExplainPlan();
    }

    private void generateValidTxnList() throws LockException {
        this.driverContext.setValidTxnListsGenerated(false);
        String currentTxnString = this.driverContext.getConf().get("hive.txn.valid.txns");
        if (this.driverContext.getTxnManager().isTxnOpen() && (currentTxnString == null || currentTxnString.isEmpty())) {
            try {
                this.recordValidTxns(this.driverContext.getTxnManager());
                this.driverContext.setValidTxnListsGenerated(true);
            }
            catch (LockException e) {
                LOG.error("Exception while acquiring valid txn list", (Throwable)e);
                throw e;
            }
        }
    }

    private void recordValidTxns(HiveTxnManager txnMgr) throws LockException {
        String oldTxnString = this.driverContext.getConf().get("hive.txn.valid.txns");
        if (oldTxnString != null && oldTxnString.length() > 0) {
            throw new IllegalStateException("calling recordValidTxn() more than once in the same " + JavaUtils.txnIdToString(txnMgr.getCurrentTxnId()));
        }
        ValidTxnList txnList = txnMgr.getValidTxns();
        String txnStr = txnList.toString();
        this.driverContext.getConf().set("hive.txn.valid.txns", txnStr);
        LOG.debug("Encoding valid txns info " + txnStr + " txnid:" + txnMgr.getCurrentTxnId());
    }

    private QueryPlan createPlan(BaseSemanticAnalyzer sem) {
        this.setSchema(sem);
        QueryPlan plan = new QueryPlan(this.driverContext.getQueryString(), sem, this.perfLogger.getStartTime("Driver.run"), this.driverContext.getQueryId(), this.driverContext.getQueryState().getHiveOperation(), this.driverContext.getSchema());
        plan.setOptimizedCBOPlan(this.context.getCalcitePlan());
        plan.setOptimizedQueryString(this.context.getOptimizedSql());
        this.driverContext.getConf().set("mapreduce.workflow.id", "hive_" + this.driverContext.getQueryId());
        this.driverContext.getConf().set("mapreduce.workflow.name", this.driverContext.getQueryString());
        if (plan.getFetchTask() != null) {
            plan.getFetchTask().initialize(this.driverContext.getQueryState(), plan, null, this.context);
        }
        return plan;
    }

    private void setSchema(BaseSemanticAnalyzer sem) {
        Schema schema = new Schema();
        if (sem == null) {
            LOG.info("No semantic analyzer, using empty schema.");
        } else if (sem.getResultSchema() != null) {
            List<FieldSchema> lst = sem.getResultSchema();
            schema = new Schema(lst, null);
        } else if (sem.getFetchTask() != null) {
            FetchTask ft = sem.getFetchTask();
            TableDesc td = ft.getTblDesc();
            if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
            }
            if (td == null) {
                LOG.info("No returning schema, using empty schema");
            } else {
                String tableName = "result";
                List<FieldSchema> lst = null;
                try {
                    lst = HiveMetaStoreUtils.getFieldsFromDeserializer(tableName, td.getDeserializer(this.driverContext.getConf()));
                }
                catch (Exception e) {
                    LOG.warn("Error getting schema: " + StringUtils.stringifyException((Throwable)e));
                }
                if (lst != null) {
                    schema = new Schema(lst, null);
                }
            }
        }
        LOG.info("Created Hive schema: " + schema);
        this.driverContext.setSchema(schema);
    }

    private void authorize(BaseSemanticAnalyzer sem) throws HiveException, CommandProcessorException {
        if (!sem.skipAuthorization() && HiveConf.getBoolVar(this.driverContext.getConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            try {
                this.perfLogger.PerfLogBegin(CLASS_NAME, "doAuthorization");
                if (this.driverContext.getQueryState().getHiveOperation() != HiveOperation.KILL_QUERY) {
                    CommandAuthorizer.doAuthorization(this.driverContext.getQueryState().getHiveOperation(), sem, this.context.getCmd());
                }
            }
            catch (AuthorizationException authExp) {
                CONSOLE.printError("Authorization failed:" + authExp.getMessage() + ". Use SHOW GRANT to get more details.");
                throw DriverUtils.createProcessorException(this.driverContext, 403, authExp.getMessage(), "42000", null);
            }
            finally {
                this.perfLogger.PerfLogEnd(CLASS_NAME, "doAuthorization");
            }
        }
    }

    private void explainOutput(BaseSemanticAnalyzer sem, QueryPlan plan) throws IOException {
        String explainOutput;
        if ((this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT) || this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT)) && (explainOutput = ExplainTask.getExplainOutput(sem, plan, this.tree, this.driverContext.getQueryState(), this.context, this.driverContext.getConf())) != null) {
            if (this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT)) {
                LOG.info("EXPLAIN output for queryid " + this.driverContext.getQueryId() + " : " + explainOutput);
            }
            if (this.driverContext.getConf().isWebUiQueryInfoCacheEnabled() && this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT)) {
                this.driverContext.getQueryDisplay().setExplainPlan(explainOutput);
            }
        }
    }

    private void handleException(Exception e) throws CommandProcessorException {
        ErrorMsg error = ErrorMsg.getErrorMsg(e.getMessage());
        String errorMessage = "FAILED: " + e.getClass().getSimpleName();
        if (error != ErrorMsg.GENERIC_ERROR) {
            errorMessage = errorMessage + " [Error " + error.getErrorCode() + "]:";
        }
        errorMessage = e instanceof IllegalArgumentException && e.getMessage() == null && e.getCause() != null ? errorMessage + " " + e.getCause().getMessage() : errorMessage + " " + e.getMessage();
        if (error == ErrorMsg.TXNMGR_NOT_ACID) {
            errorMessage = errorMessage + ". Failed command: " + this.driverContext.getQueryString();
        }
        CONSOLE.printError(errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
        throw DriverUtils.createProcessorException(this.driverContext, error.getErrorCode(), errorMessage, error.getSQLState(), e);
    }

    private void cleanUp(boolean compileError, boolean parsed, boolean deferClose) {
        if (parsed) {
            try {
                this.driverContext.getHookRunner().runAfterCompilationHook(this.context.getCmd(), compileError);
            }
            catch (Exception e) {
                LOG.warn("Failed when invoking query after-compilation hook.", (Throwable)e);
            }
        }
        double duration = (double)this.perfLogger.PerfLogEnd(CLASS_NAME, "compile") / 1000.0;
        ImmutableMap<String, Long> compileHMSTimings = Hive.dumpMetaCallTimingWithoutEx("compilation");
        this.driverContext.getQueryDisplay().setHmsTimings(QueryDisplay.Phase.COMPILATION, compileHMSTimings);
        if (this.driverState.isAborted()) {
            this.driverState.compilationInterruptedWithLocking(deferClose);
            LOG.info("Compiling command(queryId={}) has been interrupted after {} seconds", (Object)this.driverContext.getQueryId(), (Object)duration);
        } else {
            this.driverState.compilationFinishedWithLocking(compileError);
            LOG.info("Completed compiling command(queryId={}); Time taken: {} seconds", (Object)this.driverContext.getQueryId(), (Object)duration);
        }
    }
}

