/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaToolTaskUpgrade
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaToolTaskUpgrade.class);
    private String fromVersion;

    SchemaToolTaskUpgrade() {
    }

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        if (cl.hasOption("upgradeSchemaFrom")) {
            this.fromVersion = cl.getOptionValue("upgradeSchemaFrom");
        }
    }

    private void ensureFromVersion() throws HiveMetaException {
        HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo = this.schemaTool.getConnectionInfo(false);
        String dbVersion = null;
        try {
            dbVersion = this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreSchemaVersion(connectionInfo);
        }
        catch (HiveMetaException e) {
            LOG.info("Exception getting db version:" + e.getMessage());
            LOG.info("Try to initialize db schema");
        }
        if (this.fromVersion != null) {
            if (dbVersion != null && !this.fromVersion.equals(dbVersion)) {
                throw new RuntimeException("The upgradeSchemaFrom version " + this.fromVersion + " and Metastore schema version " + dbVersion + " are different.");
            }
            System.out.println("Upgrading from the user input version " + this.fromVersion);
            return;
        }
        if (dbVersion == null) {
            throw new HiveMetaException("Schema version not stored in the metastore. Metastore schema is too old or corrupt. Try specifying the version manually");
        }
        this.fromVersion = dbVersion;
        System.out.println("Upgrading from the version " + this.fromVersion);
    }

    @Override
    void execute() throws HiveMetaException {
        this.ensureFromVersion();
        if (this.schemaTool.getMetaStoreSchemaInfo().getHiveSchemaVersion().equals(this.fromVersion)) {
            System.out.println("No schema upgrade required from version " + this.fromVersion);
            return;
        }
        List<String> upgradeScripts = this.schemaTool.getMetaStoreSchemaInfo().getUpgradeScripts(this.fromVersion);
        this.schemaTool.testConnectionToMetastore();
        System.out.println("Starting upgrade metastore schema from version " + this.fromVersion + " to " + this.schemaTool.getMetaStoreSchemaInfo().getHiveSchemaVersion());
        String scriptDir = this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreScriptDir();
        try {
            for (String scriptFile : upgradeScripts) {
                System.out.println("Upgrade script " + scriptFile);
                if (this.schemaTool.isDryRun()) continue;
                this.runPreUpgrade(scriptDir, scriptFile);
                this.schemaTool.execSql(scriptDir, scriptFile);
                System.out.println("Completed " + scriptFile);
            }
        }
        catch (IOException e) {
            throw new HiveMetaException("Upgrade FAILED! Metastore state would be inconsistent !!", e);
        }
        this.schemaTool.verifySchemaVersion();
    }

    private void runPreUpgrade(String scriptDir, String scriptFile) {
        String preUpgradeScript;
        File preUpgradeScriptFile;
        int i = 0;
        while ((preUpgradeScriptFile = new File(scriptDir, preUpgradeScript = this.schemaTool.getMetaStoreSchemaInfo().getPreUpgradeScriptName(i, scriptFile))).isFile()) {
            block3: {
                try {
                    this.schemaTool.execSql(scriptDir, preUpgradeScript);
                    System.out.println("Completed " + preUpgradeScript);
                }
                catch (Exception e) {
                    System.err.println("Warning in pre-upgrade script " + preUpgradeScript + ": " + e.getMessage());
                    if (!this.schemaTool.isVerbose()) break block3;
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }
}

