/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.io.IOException;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;

class SchemaToolTaskInit
extends SchemaToolTask {
    private boolean validate = true;
    private String toVersion;

    SchemaToolTaskInit() {
    }

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        if (cl.hasOption("initSchemaTo")) {
            this.toVersion = cl.getOptionValue("initSchemaTo");
            this.validate = false;
        }
    }

    private void ensureToVersion() throws HiveMetaException {
        if (this.toVersion != null) {
            return;
        }
        this.toVersion = this.schemaTool.getMetaStoreSchemaInfo().getHiveSchemaVersion();
        System.out.println("Initializing the schema to: " + this.toVersion);
    }

    @Override
    void execute() throws HiveMetaException {
        this.ensureToVersion();
        this.schemaTool.testConnectionToMetastore();
        System.out.println("Starting metastore schema initialization to " + this.toVersion);
        String initScriptDir = this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreScriptDir();
        String initScriptFile = this.schemaTool.getMetaStoreSchemaInfo().generateInitFileName(this.toVersion);
        try {
            System.out.println("Initialization script " + initScriptFile);
            if (!this.schemaTool.isDryRun()) {
                this.schemaTool.execSql(initScriptDir, initScriptFile);
                System.out.println("Initialization script completed");
            }
        }
        catch (IOException e) {
            throw new HiveMetaException("Schema initialization FAILED! Metastore state would be inconsistent!", e);
        }
        if (this.validate) {
            this.schemaTool.verifySchemaVersion();
        }
    }
}

