/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SchemaToolCommandLine {
    private final Options cmdLineOptions;
    private final CommandLine cl;
    private final String dbType;
    private final String metaDbType;
    private static final Set<String> VALID_DB_TYPES = ImmutableSet.of("derby", "hive", "mssql", "mysql", "postgres", "oracle", new String[0]);
    private static final Set<String> VALID_META_DB_TYPES = ImmutableSet.of("derby", "mssql", "mysql", "postgres", "oracle");

    private Options createOptions(OptionGroup additionalOptions) {
        Option help = new Option("help", "print this message");
        Option infoOpt = new Option("info", "Show config and schema details");
        Option upgradeOpt = new Option("upgradeSchema", "Schema upgrade");
        OptionBuilder.withArgName((String)"upgradeFrom");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema upgrade from a version");
        Option upgradeFromOpt = OptionBuilder.create((String)"upgradeSchemaFrom");
        Option initOpt = new Option("initSchema", "Schema initialization");
        OptionBuilder.withArgName((String)"initTo");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema initialization to a version");
        Option initToOpt = OptionBuilder.create((String)"initSchemaTo");
        Option initOrUpgradeSchemaOpt = new Option("initOrUpgradeSchema", "Initialize or upgrade schema to latest version");
        Option dropDbOpt = new Option("dropAllDatabases", "Drop all Hive databases (with CASCADE). This will remove all managed data!");
        Option yesOpt = new Option("yes", "Don't ask for confirmation when using -dropAllDatabases.");
        Option validateOpt = new Option("validate", "Validate the database");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Create a catalog, requires --catalogLocation parameter as well");
        Option createCatalog = OptionBuilder.create((String)"createCatalog");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Alter a catalog, requires --catalogLocation and/or --catalogDescription parameter as well");
        Option alterCatalog = OptionBuilder.create((String)"alterCatalog");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Merge databases from a catalog into other, Argument is the source catalog name Requires --toCatalog to indicate the destination catalog");
        Option mergeCatalog = OptionBuilder.create((String)"mergeCatalog");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Move a database between catalogs.  Argument is the database name. Requires --fromCatalog and --toCatalog parameters as well");
        Option moveDatabase = OptionBuilder.create((String)"moveDatabase");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Move a table to a different database.  Argument is the table name. Requires --fromCatalog, --toCatalog, --fromDatabase, and --toDatabase  parameters as well.");
        Option moveTable = OptionBuilder.create((String)"moveTable");
        Option createUserOpt = new Option("createUser", "Create the Hive user, set hiveUser to the db admin user and the hive password to the db admin password with this");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Create table for Hive warehouse/compute logs");
        Option createLogsTable = OptionBuilder.create((String)"createLogsTable");
        OptionGroup optGroup = new OptionGroup();
        optGroup.addOption(help).addOption(infoOpt).addOption(upgradeOpt).addOption(upgradeFromOpt).addOption(initOpt).addOption(dropDbOpt).addOption(initToOpt).addOption(initOrUpgradeSchemaOpt).addOption(validateOpt).addOption(createCatalog).addOption(alterCatalog).addOption(mergeCatalog).addOption(moveDatabase).addOption(moveTable).addOption(createUserOpt).addOption(createLogsTable);
        optGroup.setRequired(true);
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Override config file user name");
        Option userNameOpt = OptionBuilder.create((String)"userName");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Override config file password");
        Option passwdOpt = OptionBuilder.create((String)"passWord");
        OptionBuilder.withArgName((String)"databaseType");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Metastore database type");
        OptionBuilder.isRequired();
        Option dbTypeOpt = OptionBuilder.create((String)"dbType");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Hive user (for use with createUser)");
        Option hiveUserOpt = OptionBuilder.create((String)"hiveUser");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Hive password (for use with createUser)");
        Option hivePasswdOpt = OptionBuilder.create((String)"hivePassword");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Hive database (for use with createUser)");
        Option hiveDbOpt = OptionBuilder.create((String)"hiveDb");
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"connection url to the database");
        Option urlOpt = OptionBuilder.create((String)"url");
        OptionBuilder.withArgName((String)"driver");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"driver name for connection");
        Option driverOpt = OptionBuilder.create((String)"driver");
        OptionBuilder.withArgName((String)"databaseOpts");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Backend DB specific options");
        Option dbOpts = OptionBuilder.create((String)"dbOpts");
        Option dryRunOpt = new Option("dryRun", "list SQL scripts (no execute)");
        Option verboseOpt = new Option("verbose", "only print SQL statements");
        OptionBuilder.withArgName((String)"serverList");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"a comma-separated list of servers used in location validation in the format of scheme://authority (e.g. hdfs://localhost:8000)");
        Option serversOpt = OptionBuilder.create((String)"servers");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location of new catalog, required when adding a catalog");
        Option catalogLocation = OptionBuilder.create((String)"catalogLocation");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Description of new catalog");
        Option catalogDescription = OptionBuilder.create((String)"catalogDescription");
        OptionBuilder.withDescription((String)"If passed then it is not an error to create an existing catalog");
        Option ifNotExists = OptionBuilder.create((String)"ifNotExists");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Catalog a moving database or table is coming from.  This is required if you are moving a database or table.");
        Option fromCatalog = OptionBuilder.create((String)"fromCatalog");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Catalog a moving database or table is going to.  This is required if you are moving a database or table.");
        Option toCatalog = OptionBuilder.create((String)"toCatalog");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Database a moving table is coming from.  This is required if you are moving a table.");
        Option fromDatabase = OptionBuilder.create((String)"fromDatabase");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Database a moving table is going to.  This is required if you are moving a table.");
        Option toDatabase = OptionBuilder.create((String)"toDatabase");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify logs table retention period");
        Option retentionPeriod = OptionBuilder.create((String)"retentionPeriod");
        Options options = new Options();
        options.addOption(help);
        options.addOptionGroup(optGroup);
        options.addOption(dbTypeOpt);
        options.addOption(userNameOpt);
        options.addOption(passwdOpt);
        options.addOption(urlOpt);
        options.addOption(driverOpt);
        options.addOption(dbOpts);
        options.addOption(dryRunOpt);
        options.addOption(verboseOpt);
        options.addOption(serversOpt);
        options.addOption(catalogLocation);
        options.addOption(catalogDescription);
        options.addOption(ifNotExists);
        options.addOption(fromCatalog);
        options.addOption(toCatalog);
        options.addOption(fromDatabase);
        options.addOption(toDatabase);
        options.addOption(hiveUserOpt);
        options.addOption(hivePasswdOpt);
        options.addOption(hiveDbOpt);
        options.addOption(yesOpt);
        options.addOption(retentionPeriod);
        if (additionalOptions != null) {
            options.addOptionGroup(additionalOptions);
        }
        return options;
    }

    public SchemaToolCommandLine(String[] args, OptionGroup additionalOptions) throws ParseException {
        this.cmdLineOptions = this.createOptions(additionalOptions);
        this.cl = this.getCommandLine(args);
        if (this.cl.hasOption("help")) {
            this.printAndExit(null);
        }
        this.dbType = this.cl.getOptionValue("dbType");
        this.metaDbType = this.cl.getOptionValue("metaDbType");
        this.validate();
    }

    private CommandLine getCommandLine(String[] args) throws ParseException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(this.cmdLineOptions, args);
        }
        catch (ParseException e) {
            this.printAndExit("HiveSchemaTool:Parsing failed. Reason: " + e.getLocalizedMessage());
            return null;
        }
    }

    private void validate() throws ParseException {
        if (!VALID_DB_TYPES.contains(this.dbType)) {
            this.printAndExit("Unsupported dbType " + this.dbType);
        }
        if (this.metaDbType != null) {
            if (!this.dbType.equals("hive")) {
                this.printAndExit("metaDbType may only be set if dbType is hive");
            }
            if (!VALID_META_DB_TYPES.contains(this.metaDbType)) {
                this.printAndExit("Unsupported metaDbType " + this.metaDbType);
            }
        } else if (this.dbType.equalsIgnoreCase("hive")) {
            System.err.println();
            this.printAndExit("metaDbType must be set if dbType is hive");
        }
        if (this.cl.hasOption("createCatalog") && !this.cl.hasOption("catalogLocation")) {
            System.err.println();
            this.printAndExit("catalogLocation must be set for createCatalog");
        }
        if (!this.cl.hasOption("createCatalog") && !this.cl.hasOption("alterCatalog") && (this.cl.hasOption("catalogLocation") || this.cl.hasOption("catalogDescription"))) {
            this.printAndExit("catalogLocation and catalogDescription may be set only for createCatalog and alterCatalog");
        }
        if (!this.cl.hasOption("createCatalog") && this.cl.hasOption("ifNotExists")) {
            this.printAndExit("ifNotExists may be set only for createCatalog");
        }
        if (this.cl.hasOption("mergeCatalog") && !this.cl.hasOption("toCatalog")) {
            this.printAndExit("mergeCatalog and toCatalog must be set for mergeCatalog");
        }
        if (!(!this.cl.hasOption("moveDatabase") || this.cl.hasOption("fromCatalog") && this.cl.hasOption("toCatalog"))) {
            this.printAndExit("fromCatalog and toCatalog must be set for moveDatabase");
        }
        if (!(!this.cl.hasOption("moveTable") || this.cl.hasOption("fromCatalog") && this.cl.hasOption("toCatalog") && this.cl.hasOption("fromDatabase") && this.cl.hasOption("toDatabase"))) {
            this.printAndExit("fromCatalog, toCatalog, fromDatabase and toDatabase must be set for moveTable");
        }
        if (!(this.cl.hasOption("moveDatabase") || this.cl.hasOption("moveTable") || this.cl.hasOption("mergeCatalog") || !this.cl.hasOption("fromCatalog") && !this.cl.hasOption("toCatalog"))) {
            this.printAndExit("fromCatalog and toCatalog may be set only for moveDatabase and moveTable");
        }
        if (!this.cl.hasOption("moveTable") && (this.cl.hasOption("fromDatabase") || this.cl.hasOption("toDatabase"))) {
            this.printAndExit("fromDatabase and toDatabase may be set only for moveTable");
        }
        if (this.cl.hasOption("dropAllDatabases") && !"hive".equals(this.dbType)) {
            this.printAndExit("dropAllDatabases can only be used with dbType=hive");
        }
        if (this.cl.hasOption("yes") && !this.cl.hasOption("dropAllDatabases")) {
            this.printAndExit("yes can only be used with dropAllDatabases");
        }
    }

    private void printAndExit(String reason) throws ParseException {
        if (reason != null) {
            System.err.println(reason);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("schemaTool", this.cmdLineOptions);
        if (reason != null) {
            throw new ParseException(reason);
        }
        System.exit(0);
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getMetaDbType() {
        return this.metaDbType;
    }

    boolean hasOption(String opt) {
        return this.cl.hasOption(opt);
    }

    String getOptionValue(String opt) {
        return this.cl.getOptionValue(opt);
    }
}

