/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;

public class LongColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        LongColumnStatsDataInspector aggregateData = ColumnsStatsUtils.longInspectorFromStats(aggregateColStats);
        LongColumnStatsDataInspector newData = ColumnsStatsUtils.longInspectorFromStats(newColStats);
        this.setLowValue(aggregateData, newData);
        this.setHighValue(aggregateData, newData);
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (aggregateData.getNdvEstimator() == null || newData.getNdvEstimator() == null) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            NumDistinctValueEstimator oldEst = aggregateData.getNdvEstimator();
            NumDistinctValueEstimator newEst = newData.getNdvEstimator();
            long ndv = -1L;
            if (oldEst.canMerge(newEst)) {
                oldEst.mergeEstimators(newEst);
                ndv = oldEst.estimateNumDistinctValues();
                aggregateData.setNdvEstimator(oldEst);
            } else {
                ndv = Math.max(aggregateData.getNumDVs(), newData.getNumDVs());
            }
            this.LOG.debug("Use bitvector to merge column " + aggregateColStats.getColName() + "'s ndvs of " + aggregateData.getNumDVs() + " and " + newData.getNumDVs() + " to be " + ndv);
            aggregateData.setNumDVs(ndv);
        }
        aggregateColStats.getStatsData().setLongStats(aggregateData);
    }

    public void setLowValue(LongColumnStatsDataInspector aggregateData, LongColumnStatsDataInspector newData) {
        if (!aggregateData.isSetLowValue() && !newData.isSetLowValue()) {
            return;
        }
        long lowValue = Math.min(aggregateData.isSetLowValue() ? aggregateData.getLowValue() : Long.MAX_VALUE, newData.isSetLowValue() ? newData.getLowValue() : Long.MAX_VALUE);
        aggregateData.setLowValue(lowValue);
    }

    public void setHighValue(LongColumnStatsDataInspector aggregateData, LongColumnStatsDataInspector newData) {
        if (!aggregateData.isSetHighValue() && !newData.isSetHighValue()) {
            return;
        }
        long highValue = Math.max(aggregateData.isSetHighValue() ? aggregateData.getHighValue() : Long.MIN_VALUE, newData.isSetHighValue() ? newData.getHighValue() : Long.MIN_VALUE);
        aggregateData.setHighValue(highValue);
    }
}

