/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.impl;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.protocol.LlapProtocolBlockingPB;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapProtocolClientImpl
implements LlapProtocolBlockingPB {
    private static final Logger LOG = LoggerFactory.getLogger(LlapProtocolClientImpl.class);
    private final Configuration conf;
    private final InetSocketAddress serverAddr;
    private final RetryPolicy retryPolicy;
    private final SocketFactory socketFactory;
    private LlapProtocolBlockingPB proxy;
    private final UserGroupInformation ugi;

    public LlapProtocolClientImpl(Configuration conf, String hostname, int port, UserGroupInformation ugi, @Nullable RetryPolicy retryPolicy, @Nullable SocketFactory socketFactory) {
        this.ugi = ugi;
        this.conf = conf;
        this.serverAddr = NetUtils.createSocketAddr((String)hostname, (int)port);
        this.retryPolicy = retryPolicy;
        this.socketFactory = socketFactory == null ? NetUtils.getDefaultSocketFactory((Configuration)conf) : socketFactory;
    }

    @Override
    public LlapDaemonProtocolProtos.RegisterDagResponseProto registerDag(RpcController controller, LlapDaemonProtocolProtos.RegisterDagRequestProto request) throws ServiceException {
        try {
            return this.getProxy().registerDag(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public LlapDaemonProtocolProtos.SubmitWorkResponseProto submitWork(RpcController controller, LlapDaemonProtocolProtos.SubmitWorkRequestProto request) throws ServiceException {
        try {
            return this.getProxy().submitWork(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto sourceStateUpdated(RpcController controller, LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto request) throws ServiceException {
        try {
            return this.getProxy().sourceStateUpdated(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public LlapDaemonProtocolProtos.QueryCompleteResponseProto queryComplete(RpcController controller, LlapDaemonProtocolProtos.QueryCompleteRequestProto request) throws ServiceException {
        try {
            return this.getProxy().queryComplete(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public LlapDaemonProtocolProtos.TerminateFragmentResponseProto terminateFragment(RpcController controller, LlapDaemonProtocolProtos.TerminateFragmentRequestProto request) throws ServiceException {
        try {
            return this.getProxy().terminateFragment(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public LlapDaemonProtocolProtos.UpdateFragmentResponseProto updateFragment(RpcController controller, LlapDaemonProtocolProtos.UpdateFragmentRequestProto request) throws ServiceException {
        try {
            return this.getProxy().updateFragment(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public LlapProtocolBlockingPB getProxy() throws IOException {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    public LlapProtocolBlockingPB createProxy() throws IOException {
        RPC.setProtocolEngine((Configuration)this.conf, LlapProtocolBlockingPB.class, ProtobufRpcEngine.class);
        LOG.info("Creating protocol proxy as " + this.ugi);
        if (this.ugi == null) {
            return this.createProxyInternal();
        }
        try {
            return (LlapProtocolBlockingPB)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<LlapProtocolBlockingPB>(){

                @Override
                public LlapProtocolBlockingPB run() throws IOException {
                    return LlapProtocolClientImpl.this.createProxyInternal();
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private LlapProtocolBlockingPB createProxyInternal() throws IOException {
        ProtocolProxy proxy = RPC.getProtocolProxy(LlapProtocolBlockingPB.class, (long)0L, (InetSocketAddress)this.serverAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)this.conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)this.conf), (int)0, (RetryPolicy)this.retryPolicy);
        return (LlapProtocolBlockingPB)proxy.getProxy();
    }
}

