/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.provider.AttemptingUserProvidingSaslServer;
import org.apache.hadoop.hbase.security.provider.GssSaslAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class GssSaslServerAuthenticationProvider
extends GssSaslAuthenticationProvider
implements SaslServerAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GssSaslServerAuthenticationProvider.class);

    @Override
    public AttemptingUserProvidingSaslServer createServer(SecretManager<TokenIdentifier> secretManager, final Map<String, String> saslProps) throws IOException {
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        String fullName = current.getUserName();
        LOG.debug("Server's Kerberos principal name is {}", (Object)fullName);
        final String[] names = SaslUtil.splitKerberosName((String)fullName);
        if (names.length != 3) {
            throw new AccessDeniedException("Kerberos principal does NOT contain an instance (hostname): " + fullName);
        }
        try {
            return (AttemptingUserProvidingSaslServer)current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AttemptingUserProvidingSaslServer>(){

                @Override
                public AttemptingUserProvidingSaslServer run() throws SaslException {
                    return new AttemptingUserProvidingSaslServer(Sasl.createSaslServer(GssSaslServerAuthenticationProvider.this.getSaslAuthMethod().getSaslMechanism(), names[0], names[1], saslProps, new SaslGssCallbackHandler()), () -> null);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Failed to construct GSS SASL server");
        }
    }

    @Override
    public boolean supportsProtocolAuthentication() {
        return true;
    }

    @Override
    public UserGroupInformation getAuthorizedUgi(String authzId, SecretManager<TokenIdentifier> secretManager) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)authzId);
        ugi.setAuthenticationMethod(this.getSaslAuthMethod().getAuthMethod());
        return ugi;
    }

    private static class SaslGssCallbackHandler
    implements CallbackHandler {
        private SaslGssCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    LOG.debug("SASL server GSSAPI callback: setting canonicalized client ID: {}", (Object)authzid);
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

