/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionSizeReportingChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(RegionSizeReportingChore.class);
    static final String REGION_SIZE_REPORTING_CHORE_PERIOD_KEY = "hbase.regionserver.quotas.region.size.reporting.chore.period";
    static final int REGION_SIZE_REPORTING_CHORE_PERIOD_DEFAULT = 60000;
    static final String REGION_SIZE_REPORTING_CHORE_DELAY_KEY = "hbase.regionserver.quotas.region.size.reporting.chore.delay";
    static final long REGION_SIZE_REPORTING_CHORE_DELAY_DEFAULT = 30000L;
    static final String REGION_SIZE_REPORTING_CHORE_TIMEUNIT_KEY = "hbase.regionserver.quotas.region.size.reporting.chore.timeunit";
    static final String REGION_SIZE_REPORTING_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    private final RegionServerServices rsServices;
    private final MetricsRegionServer metrics;

    public RegionSizeReportingChore(RegionServerServices rsServices) {
        super(RegionSizeReportingChore.class.getSimpleName(), (Stoppable)rsServices, RegionSizeReportingChore.getPeriod(rsServices.getConfiguration()), RegionSizeReportingChore.getInitialDelay(rsServices.getConfiguration()), RegionSizeReportingChore.getTimeUnit(rsServices.getConfiguration()));
        this.rsServices = rsServices;
        this.metrics = rsServices.getMetrics();
    }

    protected void chore() {
        long start = System.nanoTime();
        try {
            this._chore();
        }
        finally {
            if (this.metrics != null) {
                this.metrics.incrementRegionSizeReportingChoreTime(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
        }
    }

    void _chore() {
        RegionServerSpaceQuotaManager quotaManager = this.rsServices.getRegionServerSpaceQuotaManager();
        HashSet<RegionInfo> onlineRegionInfos = this.getOnlineRegionInfos(this.rsServices.getRegions());
        RegionSizeStore store = quotaManager.getRegionSizeStore();
        this.removeNonOnlineRegions(store, onlineRegionInfos);
        this.rsServices.reportRegionSizesForQuotas(store);
    }

    HashSet<RegionInfo> getOnlineRegionInfos(List<? extends Region> onlineRegions) {
        HashSet<RegionInfo> regionInfos = new HashSet<RegionInfo>();
        onlineRegions.forEach(region -> regionInfos.add(region.getRegionInfo()));
        return regionInfos;
    }

    void removeNonOnlineRegions(RegionSizeStore store, Set<RegionInfo> onlineRegions) {
        if (onlineRegions.isEmpty()) {
            store.clear();
            return;
        }
        Iterator iter = store.iterator();
        int numEntriesRemoved = 0;
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            RegionInfo regionInfo = (RegionInfo)entry.getKey();
            if (onlineRegions.contains(regionInfo)) continue;
            ++numEntriesRemoved;
            iter.remove();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removed " + numEntriesRemoved + " region sizes before reporting to Master " + "because they are for non-online regions.");
        }
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(REGION_SIZE_REPORTING_CHORE_PERIOD_KEY, 60000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(REGION_SIZE_REPORTING_CHORE_DELAY_KEY, 30000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(REGION_SIZE_REPORTING_CHORE_TIMEUNIT_KEY, REGION_SIZE_REPORTING_CHORE_TIMEUNIT_DEFAULT));
    }
}

