/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultMobStoreCompactor
extends DefaultCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMobStoreCompactor.class);
    protected long mobSizeThreshold;
    protected HMobStore mobStore;
    protected boolean ioOptimizedMode = false;
    static ThreadLocal<Set<String>> mobRefSet = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };
    static ThreadLocal<Boolean> userRequest = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    static ThreadLocal<Boolean> disableIO = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    static ThreadLocal<HashMap<String, Long>> mobLengthMap = new ThreadLocal<HashMap<String, Long>>(){

        @Override
        protected HashMap<String, Long> initialValue() {
            return new HashMap<String, Long>();
        }
    };
    private final Compactor.InternalScannerFactory scannerFactory = new Compactor.InternalScannerFactory(){

        @Override
        public ScanType getScanType(CompactionRequestImpl request) {
            return request.isAllFiles() ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
        }

        @Override
        public InternalScanner createScanner(ScanInfo scanInfo, List<StoreFileScanner> scanners, ScanType scanType, Compactor.FileDetails fd, long smallestReadPoint) throws IOException {
            return new StoreScanner(DefaultMobStoreCompactor.this.store, scanInfo, scanners, scanType, smallestReadPoint, fd.earliestPutTs);
        }
    };
    private final Compactor.CellSinkFactory<StoreFileWriter> writerFactory = new Compactor.CellSinkFactory<StoreFileWriter>(){

        @Override
        public StoreFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
            return DefaultMobStoreCompactor.this.store.createWriterInTmp(fd.maxKeyCount, DefaultMobStoreCompactor.this.compactionCompression, true, true, true, shouldDropBehind);
        }
    };

    public DefaultMobStoreCompactor(Configuration conf, HStore store) {
        super(conf, store);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobStore = (HMobStore)store;
        this.mobSizeThreshold = store.getColumnFamilyDescriptor().getMobThreshold();
        this.ioOptimizedMode = conf.get("hbase.mob.compaction.type", "full").equals("optimized");
    }

    @Override
    public List<Path> compact(CompactionRequestImpl request, ThroughputController throughputController, User user) throws IOException {
        String tableName = this.store.getTableName().toString();
        String regionName = this.store.getRegionInfo().getRegionNameAsString();
        String familyName = this.store.getColumnFamilyName();
        LOG.info("MOB compaction: major={} isAll={} priority={} throughput controller={} table={} cf={} region={}", new Object[]{request.isMajor(), request.isAllFiles(), request.getPriority(), throughputController, tableName, familyName, regionName});
        if (request.getPriority() == 1) {
            userRequest.set(Boolean.TRUE);
        } else {
            userRequest.set(Boolean.FALSE);
        }
        LOG.debug("MOB compaction table={} cf={} region={} files: {}", new Object[]{tableName, familyName, regionName, request.getFiles()});
        if (this.ioOptimizedMode && request.isMajor() && request.getPriority() == 1) {
            Path mobDir = MobUtils.getMobFamilyPath(this.conf, this.store.getTableName(), this.store.getColumnFamilyName());
            List<Path> mobFiles = MobUtils.getReferencedMobFiles(request.getFiles(), mobDir);
            disableIO.set(Boolean.FALSE);
            if (mobFiles.size() > 0) {
                this.calculateMobLengthMap(mobFiles);
            }
            LOG.info("Table={} cf={} region={}. I/O optimized MOB compaction. Total referenced MOB files: {}", new Object[]{tableName, familyName, regionName, mobFiles.size()});
        }
        return this.compact(request, this.scannerFactory, this.writerFactory, throughputController, user);
    }

    private void calculateMobLengthMap(List<Path> mobFiles) throws IOException {
        FileSystem fs = this.store.getFileSystem();
        HashMap<String, Long> map = mobLengthMap.get();
        map.clear();
        for (Path p : mobFiles) {
            if (MobFileName.isOldMobFileName(p.getName())) {
                disableIO.set(Boolean.TRUE);
            }
            FileStatus st = fs.getFileStatus(p);
            long size = st.getLen();
            LOG.debug("Referenced MOB file={} size={}", (Object)p, (Object)size);
            map.put(p.getName(), fs.getFileStatus(p).getLen());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean performCompaction(Compactor.FileDetails fd, InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController, boolean major, int numofFilesToCompact) throws IOException {
        long bytesWrittenProgressForCloseCheck = 0L;
        long bytesWrittenProgressForLog = 0L;
        long bytesWrittenProgressForShippedCall = 0L;
        mobRefSet.get().clear();
        boolean isUserRequest = userRequest.get();
        boolean compactMOBs = major && isUserRequest;
        boolean discardMobMiss = this.conf.getBoolean("hbase.unsafe.mob.discard.miss", false);
        if (discardMobMiss) {
            LOG.warn("{}=true. This is unsafe setting recommended only when first upgrading to a version with the distributed mob compaction feature on a cluster that has experienced MOB data corruption.", (Object)"hbase.unsafe.mob.discard.miss");
        }
        long maxMobFileSize = this.conf.getLong("hbase.mob.compactions.max.file.size", 0x40000000L);
        boolean ioOptimizedMode = this.ioOptimizedMode && disableIO.get() == false;
        LOG.info("Compact MOB={} optimized configured={} optimized enabled={} maximum MOB file size={} major={} store={}", new Object[]{compactMOBs, this.ioOptimizedMode, ioOptimizedMode, maxMobFileSize, major, this.getStoreInfo()});
        ArrayList<Cell> cells = new ArrayList<Cell>();
        int closeCheckSizeLimit = HStore.getCloseCheckInterval();
        long lastMillis = 0L;
        if (LOG.isDebugEnabled()) {
            lastMillis = EnvironmentEdgeManager.currentTime();
        }
        String compactionName = ThroughputControlUtil.getNameForThrottling(this.store, "compaction");
        long now = 0L;
        byte[] fileName = null;
        StoreFileWriter mobFileWriter = null;
        long mobCells = 0L;
        long cellsCountCompactedToMob = 0L;
        long cellsCountCompactedFromMob = 0L;
        long cellsSizeCompactedToMob = 0L;
        long cellsSizeCompactedFromMob = 0L;
        boolean finished = false;
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
        throughputController.start(compactionName);
        KeyValueScanner kvs = scanner instanceof KeyValueScanner ? (KeyValueScanner)((Object)scanner) : null;
        long shippedCallSizeLimit = (long)numofFilesToCompact * (long)this.store.getColumnFamilyDescriptor().getBlocksize();
        Cell mobCell = null;
        try {
            boolean hasMore;
            mobFileWriter = this.newMobWriter(fd);
            fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
            do {
                hasMore = scanner.next(cells, scannerContext);
                now = EnvironmentEdgeManager.currentTime();
                for (Cell c : cells) {
                    block40: {
                        block36: {
                            block37: {
                                block38: {
                                    String fName;
                                    block39: {
                                        if (!compactMOBs) break block36;
                                        if (!MobUtils.isMobReferenceCell(c)) break block37;
                                        fName = MobUtils.getMobFileName(c);
                                        try {
                                            mobCell = this.mobStore.resolve(c, true, false);
                                        }
                                        catch (FileNotFoundException fnfe) {
                                            if (!discardMobMiss) throw fnfe;
                                            LOG.error("Missing MOB cell: file={} not found cell={}", (Object)fName, (Object)c);
                                            continue;
                                        }
                                        if (discardMobMiss && mobCell.getValueLength() == 0) {
                                            LOG.error("Missing MOB cell value: file={} mob cell={} cell={}", new Object[]{fName, mobCell, c});
                                            continue;
                                        }
                                        if (mobCell.getValueLength() == 0) {
                                            String errMsg = String.format("Found 0 length MOB cell in a file=%s mob cell=%s  cell=%s", fName, mobCell, c);
                                            throw new IOException(errMsg);
                                        }
                                        if ((long)mobCell.getValueLength() <= this.mobSizeThreshold) break block38;
                                        PrivateCellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                        if (ioOptimizedMode) break block39;
                                        mobFileWriter.append(mobCell);
                                        ++mobCells;
                                        writer.append(MobUtils.createMobRefCell(mobCell, fileName, this.mobStore.getRefCellTags()));
                                        break block40;
                                    }
                                    Long size = mobLengthMap.get().get(fName);
                                    if (size == null) {
                                        String msg = String.format("Found an unexpected MOB file during compaction %s, aborting compaction %s", fName, this.getStoreInfo());
                                        throw new IOException(msg);
                                    }
                                    if (size < maxMobFileSize) {
                                        mobFileWriter.append(mobCell);
                                        ++mobCells;
                                        writer.append(MobUtils.createMobRefCell(mobCell, fileName, this.mobStore.getRefCellTags()));
                                        long len = mobFileWriter.getPos();
                                        if (len > maxMobFileSize) {
                                            LOG.debug("Closing output MOB File, length={} file={}, store={}", new Object[]{len, mobFileWriter.getPath().getName(), this.getStoreInfo()});
                                            this.commitOrAbortMobWriter(mobFileWriter, fd.maxSeqId, mobCells, major);
                                            mobFileWriter = this.newMobWriter(fd);
                                            fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
                                            mobCells = 0L;
                                        }
                                        break block40;
                                    } else {
                                        mobRefSet.get().add(fName);
                                        writer.append(mobCell);
                                    }
                                    break block40;
                                }
                                PrivateCellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                writer.append(mobCell);
                                ++cellsCountCompactedFromMob;
                                cellsSizeCompactedFromMob += (long)mobCell.getValueLength();
                                break block40;
                            }
                            int size = c.getValueLength();
                            if ((long)size > this.mobSizeThreshold) {
                                long len;
                                mobFileWriter.append(c);
                                writer.append(MobUtils.createMobRefCell(c, fileName, this.mobStore.getRefCellTags()));
                                ++mobCells;
                                ++cellsCountCompactedToMob;
                                cellsSizeCompactedToMob += (long)c.getValueLength();
                                if (ioOptimizedMode && (len = mobFileWriter.getPos()) > maxMobFileSize) {
                                    this.commitOrAbortMobWriter(mobFileWriter, fd.maxSeqId, mobCells, major);
                                    mobFileWriter = this.newMobWriter(fd);
                                    fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
                                    mobCells = 0L;
                                }
                                break block40;
                            } else {
                                writer.append(c);
                            }
                            break block40;
                        }
                        if (c.getTypeByte() != KeyValue.Type.Put.getCode()) {
                            writer.append(c);
                        } else if (MobUtils.isMobReferenceCell(c)) {
                            if (!MobUtils.hasValidMobRefCellValue(c)) {
                                String errMsg = String.format("Corrupted MOB reference: %s", c.toString());
                                throw new IOException(errMsg);
                            }
                            writer.append(c);
                            mobRefSet.get().add(MobUtils.getMobFileName(c));
                        } else if ((long)c.getValueLength() <= this.mobSizeThreshold) {
                            writer.append(c);
                        } else {
                            long len;
                            ++mobCells;
                            mobFileWriter.append(c);
                            Cell reference = MobUtils.createMobRefCell(c, fileName, this.mobStore.getRefCellTags());
                            writer.append(reference);
                            ++cellsCountCompactedToMob;
                            cellsSizeCompactedToMob += (long)c.getValueLength();
                            if (ioOptimizedMode && (len = mobFileWriter.getPos()) > maxMobFileSize) {
                                this.commitOrAbortMobWriter(mobFileWriter, fd.maxSeqId, mobCells, major);
                                mobFileWriter = this.newMobWriter(fd);
                                fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
                                mobCells = 0L;
                            }
                        }
                    }
                    int len = c.getSerializedSize();
                    ++this.progress.currentCompactedKVs;
                    this.progress.totalCompactedSize += (long)len;
                    bytesWrittenProgressForShippedCall += (long)len;
                    if (LOG.isDebugEnabled()) {
                        bytesWrittenProgressForLog += (long)len;
                    }
                    throughputController.control(compactionName, len);
                    if (closeCheckSizeLimit > 0 && (bytesWrittenProgressForCloseCheck += (long)len) > (long)closeCheckSizeLimit) {
                        bytesWrittenProgressForCloseCheck = 0L;
                        if (!this.store.areWritesEnabled()) {
                            this.progress.cancel();
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (kvs == null || bytesWrittenProgressForShippedCall <= shippedCallSizeLimit) continue;
                    ((ShipperListener)((Object)writer)).beforeShipped();
                    kvs.shipped();
                    bytesWrittenProgressForShippedCall = 0L;
                }
                if (LOG.isDebugEnabled() && now - lastMillis >= 60000L) {
                    String rate = String.format("%.2f", (double)bytesWrittenProgressForLog / 1024.0 / ((double)(now - lastMillis) / 1000.0));
                    LOG.debug("Compaction progress: {} {}, rate={} KB/sec, throughputController is {}", new Object[]{compactionName, this.progress, rate, throughputController});
                    lastMillis = now;
                    bytesWrittenProgressForLog = 0L;
                }
                cells.clear();
            } while (hasMore);
            finished = true;
        }
        catch (InterruptedException e) {
            this.progress.cancel();
            throw new InterruptedIOException("Interrupted while control throughput of compacting " + compactionName);
        }
        catch (IOException t) {
            String msg = "Mob compaction failed for region: " + this.store.getRegionInfo().getEncodedName();
            throw new IOException(msg, t);
        }
        finally {
            ((ShipperListener)((Object)writer)).beforeShipped();
            throughputController.finish(compactionName);
            if (!finished && mobFileWriter != null) {
                mobRefSet.get().clear();
                LOG.debug("Aborting writer for {} because of a compaction failure, Store {}", (Object)mobFileWriter.getPath(), (Object)this.getStoreInfo());
                this.abortWriter(mobFileWriter);
            }
        }
        this.commitOrAbortMobWriter(mobFileWriter, fd.maxSeqId, mobCells, major);
        this.mobStore.updateCellsCountCompactedFromMob(cellsCountCompactedFromMob);
        this.mobStore.updateCellsCountCompactedToMob(cellsCountCompactedToMob);
        this.mobStore.updateCellsSizeCompactedFromMob(cellsSizeCompactedFromMob);
        this.mobStore.updateCellsSizeCompactedToMob(cellsSizeCompactedToMob);
        this.progress.complete();
        return true;
    }

    private String getStoreInfo() {
        return String.format("[table=%s family=%s region=%s]", this.store.getTableName().getNameAsString(), this.store.getColumnFamilyName(), this.store.getRegionInfo().getEncodedName());
    }

    private void clearThreadLocals() {
        HashMap<String, Long> map;
        Set<String> set = mobRefSet.get();
        if (set != null) {
            set.clear();
        }
        if ((map = mobLengthMap.get()) != null) {
            map.clear();
        }
    }

    private StoreFileWriter newMobWriter(Compactor.FileDetails fd) throws IOException {
        try {
            StoreFileWriter mobFileWriter = this.mobStore.createWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, this.compactionCompression, this.store.getRegionInfo().getStartKey(), true);
            LOG.debug("New MOB writer created={} store={}", (Object)mobFileWriter.getPath().getName(), (Object)this.getStoreInfo());
            mobRefSet.get().add(mobFileWriter.getPath().getName());
            return mobFileWriter;
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to create mob writer, store=%s", this.getStoreInfo()), e);
        }
    }

    private void commitOrAbortMobWriter(StoreFileWriter mobFileWriter, long maxSeqId, long mobCells, boolean major) throws IOException {
        if (mobFileWriter != null) {
            LOG.debug("Commit or abort size={} mobCells={} major={} file={}, store={}", new Object[]{mobFileWriter.getPos(), mobCells, major, mobFileWriter.getPath().getName(), this.getStoreInfo()});
            Path path = MobUtils.getMobFamilyPath(this.conf, this.store.getTableName(), this.store.getColumnFamilyName());
            if (mobCells > 0L) {
                mobFileWriter.appendMetadata(maxSeqId, major, mobCells);
                mobFileWriter.close();
                this.mobStore.commitFile(mobFileWriter.getPath(), path);
            } else {
                LOG.debug("Aborting writer for {} because there are no MOB cells, store={}", (Object)mobFileWriter.getPath(), (Object)this.getStoreInfo());
                mobRefSet.get().remove(mobFileWriter.getPath().getName());
                this.abortWriter(mobFileWriter);
            }
        } else {
            LOG.debug("Mob file writer is null, skipping commit/abort, store=", (Object)this.getStoreInfo());
        }
    }

    @Override
    protected List<Path> commitWriter(StoreFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
        ArrayList newFiles = Lists.newArrayList((Object[])new Path[]{writer.getPath()});
        writer.appendMetadata(fd.maxSeqId, request.isAllFiles(), request.getFiles());
        Set<String> refSet = mobRefSet.get();
        writer.appendMobMetadata(refSet);
        writer.close();
        this.clearThreadLocals();
        return newFiles;
    }
}

