/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManagerUtil;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitTableRegionProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.SplitTableRegionState> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitTableRegionProcedure.class);
    private RegionInfo daughter_1_RI;
    private RegionInfo daughter_2_RI;
    private byte[] bestSplitRow;
    private RegionSplitPolicy splitPolicy;
    private static final RegionState.State[] EXPECTED_SPLIT_STATES = new RegionState.State[]{RegionState.State.OPEN, RegionState.State.CLOSED};

    public SplitTableRegionProcedure() {
    }

    public SplitTableRegionProcedure(MasterProcedureEnv env, RegionInfo regionToSplit, byte[] splitRow) throws IOException {
        super(env, regionToSplit);
        this.preflightChecks(env, true);
        SplitTableRegionProcedure.checkOnline(env, regionToSplit);
        this.bestSplitRow = splitRow;
        this.checkSplittable(env, regionToSplit, this.bestSplitRow);
        TableName table = regionToSplit.getTable();
        long rid = SplitTableRegionProcedure.getDaughterRegionIdTimestamp(regionToSplit);
        this.daughter_1_RI = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(regionToSplit.getStartKey()).setEndKey(this.bestSplitRow).setSplit(false).setRegionId(rid).build();
        this.daughter_2_RI = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(this.bestSplitRow).setEndKey(regionToSplit.getEndKey()).setSplit(false).setRegionId(rid).build();
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        if (htd.getRegionSplitPolicyClassName() != null) {
            Class<? extends RegionSplitPolicy> clazz = RegionSplitPolicy.getSplitPolicyClass(htd, env.getMasterConfiguration());
            this.splitPolicy = (RegionSplitPolicy)((Object)ReflectionUtils.newInstance(clazz, (Configuration)env.getMasterConfiguration()));
        }
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitRegions((Procedure<?>)this, this.getTableName(), this.getParentRegion(), this.daughter_1_RI, this.daughter_2_RI)) {
            try {
                LOG.debug(Procedure.LockState.LOCK_EVENT_WAIT + " " + env.getProcedureScheduler().dumpLocks());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeRegions((Procedure<?>)this, this.getTableName(), this.getParentRegion(), this.daughter_1_RI, this.daughter_2_RI);
    }

    private void checkSplittable(MasterProcedureEnv env, RegionInfo regionToSplit, byte[] splitRow) throws IOException {
        if (regionToSplit.getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't invoke split on non-default regions directly");
        }
        RegionStateNode node = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getParentRegion());
        IOException splittableCheckIOE = null;
        boolean splittable = false;
        if (node != null) {
            try {
                if (this.bestSplitRow == null || this.bestSplitRow.length == 0) {
                    LOG.info("splitKey isn't explicitly specified, will try to find a best split key from RS");
                }
                AdminProtos.GetRegionInfoResponse response = AssignmentManagerUtil.getRegionInfoResponse(env, node.getRegionLocation(), node.getRegionInfo(), true);
                if (this.bestSplitRow == null || this.bestSplitRow.length == 0) {
                    this.bestSplitRow = response.hasBestSplitRow() ? response.getBestSplitRow().toByteArray() : null;
                }
                boolean bl = splittable = response.hasSplittable() && response.getSplittable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Splittable=" + splittable + " " + node.toShortString());
                }
            }
            catch (IOException e) {
                splittableCheckIOE = e;
            }
        }
        if (!splittable) {
            DoNotRetryIOException e = new DoNotRetryIOException(regionToSplit.getShortNameToLog() + " NOT splittable");
            if (splittableCheckIOE != null) {
                e.initCause(splittableCheckIOE);
            }
            throw e;
        }
        if (this.bestSplitRow == null || this.bestSplitRow.length == 0) {
            throw new DoNotRetryIOException("Region not splittable because bestSplitPoint = null, maybe table is too small for auto split. For force split, try specifying split row");
        }
        if (Bytes.equals((byte[])regionToSplit.getStartKey(), (byte[])this.bestSplitRow)) {
            throw new DoNotRetryIOException("Split row is equal to startkey: " + Bytes.toStringBinary((byte[])splitRow));
        }
        if (!regionToSplit.containsRow(this.bestSplitRow)) {
            throw new DoNotRetryIOException("Split row is not inside region key range splitKey:" + Bytes.toStringBinary((byte[])splitRow) + " region: " + regionToSplit);
        }
    }

    private static long getDaughterRegionIdTimestamp(RegionInfo hri) {
        long rid = EnvironmentEdgeManager.currentTime();
        if (rid < hri.getRegionId()) {
            LOG.warn("Clock skew; parent regions id is " + hri.getRegionId() + " but current time here is " + rid);
            rid = hri.getRegionId() + 1L;
        }
        return rid;
    }

    private void removeNonDefaultReplicas(MasterProcedureEnv env) throws IOException {
        AssignmentManagerUtil.removeNonDefaultReplicas(env, Stream.of(this.getParentRegion()), this.getRegionReplication(env));
    }

    private void checkClosedRegions(MasterProcedureEnv env) throws IOException {
        AssignmentManagerUtil.checkClosedRegion(env, this.getParentRegion());
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SplitTableRegionState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case SPLIT_TABLE_REGION_PREPARE: {
                    if (this.prepareSplitRegion(env)) {
                        this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION);
                        break;
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION: {
                    this.preSplitRegion(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_CLOSE_PARENT_REGION);
                    break;
                }
                case SPLIT_TABLE_REGION_CLOSE_PARENT_REGION: {
                    this.addChildProcedure((Procedure[])this.createUnassignProcedures(env));
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGIONS_CHECK_CLOSED_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    this.checkClosedRegions(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS: {
                    this.removeNonDefaultReplicas(env);
                    this.createDaughterRegions(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_WRITE_MAX_SEQUENCE_ID_FILE);
                    break;
                }
                case SPLIT_TABLE_REGION_WRITE_MAX_SEQUENCE_ID_FILE: {
                    this.writeMaxSequenceIdFile(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_META);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_META: {
                    this.preSplitRegionBeforeMETA(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_UPDATE_META);
                    break;
                }
                case SPLIT_TABLE_REGION_UPDATE_META: {
                    this.updateMeta(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META: {
                    this.preSplitRegionAfterMETA(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: {
                    this.addChildProcedure((Procedure[])this.createAssignProcedures(env));
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_POST_OPERATION);
                    break;
                }
                case SPLIT_TABLE_REGION_POST_OPERATION: {
                    this.postSplitRegion(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            String msg = "Splitting " + this.getParentRegion().getEncodedName() + ", " + this;
            if (!this.isRollbackSupported(state)) {
                LOG.warn(msg, (Throwable)e);
            }
            LOG.error(msg, (Throwable)e);
            this.setFailure("master-split-regions", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SplitTableRegionState state) throws IOException, InterruptedException {
        LOG.trace("{} rollback state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case SPLIT_TABLE_REGION_UPDATE_META: 
                case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META: 
                case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: 
                case SPLIT_TABLE_REGION_POST_OPERATION: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_META: {
                    break;
                }
                case SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS: 
                case SPLIT_TABLE_REGION_WRITE_MAX_SEQUENCE_ID_FILE: {
                    break;
                }
                case SPLIT_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    break;
                }
                case SPLIT_TABLE_REGION_CLOSE_PARENT_REGION: {
                    this.openParentRegion(env);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION: {
                    this.postRollBackSplitRegion(env);
                    break;
                }
                case SPLIT_TABLE_REGION_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("pid=" + this.getProcId() + " failed rollback attempt step " + state + " for splitting the region " + this.getParentRegion().getEncodedName() + " in table " + this.getTableName(), (Throwable)e);
            throw e;
        }
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.SplitTableRegionState state) {
        switch (state) {
            case SPLIT_TABLE_REGION_UPDATE_META: 
            case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META: 
            case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: 
            case SPLIT_TABLE_REGION_POST_OPERATION: {
                return false;
            }
        }
        return true;
    }

    protected MasterProcedureProtos.SplitTableRegionState getState(int stateId) {
        return MasterProcedureProtos.SplitTableRegionState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.SplitTableRegionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.SplitTableRegionState getInitialState() {
        return MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.SplitTableRegionStateData.Builder splitTableRegionMsg = MasterProcedureProtos.SplitTableRegionStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setParentRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.getRegion())).addChildRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.daughter_1_RI)).addChildRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.daughter_2_RI));
        serializer.serialize((Message)splitTableRegionMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.SplitTableRegionStateData splitTableRegionsMsg = (MasterProcedureProtos.SplitTableRegionStateData)serializer.deserialize(MasterProcedureProtos.SplitTableRegionStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(splitTableRegionsMsg.getUserInfo()));
        this.setRegion(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)splitTableRegionsMsg.getParentRegionInfo()));
        assert (splitTableRegionsMsg.getChildRegionInfoCount() == 2);
        this.daughter_1_RI = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)splitTableRegionsMsg.getChildRegionInfo(0));
        this.daughter_2_RI = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)splitTableRegionsMsg.getChildRegionInfo(1));
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", parent=");
        sb.append(this.getParentRegion().getShortNameToLog());
        sb.append(", daughterA=");
        sb.append(this.daughter_1_RI.getShortNameToLog());
        sb.append(", daughterB=");
        sb.append(this.daughter_2_RI.getShortNameToLog());
    }

    private RegionInfo getParentRegion() {
        return this.getRegion();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_SPLIT;
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getSplitProcMetrics();
    }

    private byte[] getSplitRow() {
        return this.daughter_2_RI.getStartKey();
    }

    @VisibleForTesting
    public boolean prepareSplitRegion(MasterProcedureEnv env) throws IOException {
        if (env.getMasterServices().getSnapshotManager().isTakingSnapshot(this.getParentRegion().getTable())) {
            this.setFailure(new IOException("Skip splitting region " + this.getParentRegion().getShortNameToLog() + ", because we are taking snapshot for the table " + this.getParentRegion().getTable()));
            return false;
        }
        RegionStateNode node = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getParentRegion());
        if (node == null) {
            throw new UnknownRegionException(this.getParentRegion().getRegionNameAsString());
        }
        RegionInfo parentHRI = node.getRegionInfo();
        if (parentHRI == null) {
            LOG.info("Unsplittable; parent region is null; node={}", (Object)node);
            return false;
        }
        if (node.isInState(RegionState.State.SPLIT)) {
            LOG.info("Split of " + parentHRI + " skipped; state is already SPLIT");
            return false;
        }
        if (parentHRI.isSplit() || parentHRI.isOffline()) {
            LOG.info("Split of " + parentHRI + " skipped because offline/split.");
            return false;
        }
        if (!node.isInState(EXPECTED_SPLIT_STATES)) {
            this.setFailure(new IOException("Split " + parentHRI.getRegionNameAsString() + " FAILED because state=" + node.getState() + "; expected " + Arrays.toString(EXPECTED_SPLIT_STATES)));
            return false;
        }
        if (!env.getMasterServices().isSplitOrMergeEnabled(MasterSwitchType.SPLIT)) {
            LOG.warn("pid=" + this.getProcId() + " split switch is off! skip split of " + parentHRI);
            this.setFailure(new IOException("Split region " + parentHRI.getRegionNameAsString() + " failed due to split switch off"));
            return false;
        }
        if (!env.getMasterServices().getTableDescriptors().get(this.getTableName()).isSplitEnabled()) {
            LOG.warn("pid={}, split is disabled for the table! Skipping split of {}", (Object)this.getProcId(), (Object)parentHRI);
            this.setFailure(new IOException("Split region " + parentHRI.getRegionNameAsString() + " failed as region split is disabled for the table"));
            return false;
        }
        node.setState(RegionState.State.SPLITTING, new RegionState.State[0]);
        return true;
    }

    private void preSplitRegion(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitRegionAction(this.getTableName(), this.getSplitRow(), this.getUser());
        }
        try {
            env.getMasterServices().getMasterQuotaManager().onRegionSplit(this.getParentRegion());
        }
        catch (QuotaExceededException e) {
            env.getMasterServices().getRegionNormalizer().planSkipped(this.getParentRegion(), NormalizationPlan.PlanType.SPLIT);
            throw e;
        }
    }

    private void postRollBackSplitRegion(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRollBackSplitRegionAction(this.getUser());
        }
    }

    private void openParentRegion(MasterProcedureEnv env) throws IOException {
        AssignmentManagerUtil.reopenRegionsForRollback(env, Collections.singletonList(this.getParentRegion()), this.getRegionReplication(env), this.getParentRegionServerName(env));
    }

    @VisibleForTesting
    public void createDaughterRegions(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tabledir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)this.getTableName());
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.getParentRegion(), false);
        regionFs.createSplitsDir(this.daughter_1_RI, this.daughter_2_RI);
        Pair<Integer, Integer> expectedReferences = this.splitStoreFiles(env, regionFs);
        this.assertReferenceFileCount(fs, (Integer)expectedReferences.getFirst(), regionFs.getSplitsDir(this.daughter_1_RI));
        regionFs.commitDaughterRegion(this.daughter_1_RI);
        this.assertReferenceFileCount(fs, (Integer)expectedReferences.getFirst(), new Path(tabledir, this.daughter_1_RI.getEncodedName()));
        this.assertReferenceFileCount(fs, (Integer)expectedReferences.getSecond(), regionFs.getSplitsDir(this.daughter_2_RI));
        regionFs.commitDaughterRegion(this.daughter_2_RI);
        this.assertReferenceFileCount(fs, (Integer)expectedReferences.getSecond(), new Path(tabledir, this.daughter_2_RI.getEncodedName()));
    }

    private Pair<Integer, Integer> splitStoreFiles(MasterProcedureEnv env, HRegionFileSystem regionFs) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Configuration conf = env.getMasterConfiguration();
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        int nbFiles = 0;
        HashMap files = new HashMap(htd.getColumnFamilyCount());
        for (ColumnFamilyDescriptor cfd : htd.getColumnFamilies()) {
            String string = cfd.getNameAsString();
            Collection<StoreFileInfo> sfis = regionFs.getStoreFiles(string);
            if (sfis == null) continue;
            ArrayList<StoreFileInfo> filteredSfis = null;
            for (StoreFileInfo storeFileInfo : sfis) {
                if (storeFileInfo.isReference()) {
                    LOG.info("Skipping split of " + storeFileInfo + "; presuming ready for archiving.");
                    continue;
                }
                if (filteredSfis == null) {
                    filteredSfis = new ArrayList<StoreFileInfo>(sfis.size());
                    files.put(string, filteredSfis);
                }
                filteredSfis.add(storeFileInfo);
                ++nbFiles;
            }
        }
        if (nbFiles == 0) {
            return new Pair((Object)0, (Object)0);
        }
        int maxThreads = Math.min(conf.getInt("hbase.regionserver.region.split.threads.max", conf.getInt("hbase.hstore.blockingStoreFiles", 16)), nbFiles);
        LOG.info("pid=" + this.getProcId() + " splitting " + nbFiles + " storefiles, region=" + this.getParentRegion().getShortNameToLog() + ", threads=" + maxThreads);
        ExecutorService threadPool = Executors.newFixedThreadPool(maxThreads, Threads.newDaemonThreadFactory((String)"StoreFileSplitter-%1$d"));
        ArrayList<Future<Pair<Path, Path>>> futures = new ArrayList<Future<Pair<Path, Path>>>(nbFiles);
        for (Map.Entry entry : files.entrySet()) {
            byte[] familyName = Bytes.toBytes((String)((String)entry.getKey()));
            ColumnFamilyDescriptor hcd = htd.getColumnFamily(familyName);
            Collection storeFiles = (Collection)entry.getValue();
            if (storeFiles == null || storeFiles.size() <= 0) continue;
            for (StoreFileInfo storeFileInfo : storeFiles) {
                StoreFileSplitter sfs = new StoreFileSplitter(regionFs, familyName, new HStoreFile(mfs.getFileSystem(), storeFileInfo, conf, CacheConfig.DISABLED, hcd.getBloomFilterType(), true));
                futures.add(threadPool.submit(sfs));
            }
        }
        threadPool.shutdown();
        long fileSplitTimeout = conf.getLong("hbase.master.fileSplitTimeout", conf.getLong("hbase.regionserver.fileSplitTimeout", 600000L));
        try {
            boolean stillRunning;
            boolean bl = stillRunning = !threadPool.awaitTermination(fileSplitTimeout, TimeUnit.MILLISECONDS);
            if (stillRunning) {
                threadPool.shutdownNow();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(50L);
                }
                throw new IOException("Took too long to split the files and create the references, aborting split");
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        int daughterA = 0;
        int daughterB = 0;
        for (Future future : futures) {
            try {
                Pair p = (Pair)future.get();
                daughterA += p.getFirst() != null ? 1 : 0;
                daughterB += p.getSecond() != null ? 1 : 0;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pid=" + this.getProcId() + " split storefiles for region " + this.getParentRegion().getShortNameToLog() + " Daughter A: " + daughterA + " storefiles, Daughter B: " + daughterB + " storefiles.");
        }
        return new Pair((Object)daughterA, (Object)daughterB);
    }

    private void assertReferenceFileCount(FileSystem fs, int expectedReferenceFileCount, Path dir) throws IOException {
        if (expectedReferenceFileCount != 0 && expectedReferenceFileCount != FSUtils.getRegionReferenceFileCount(fs, dir)) {
            throw new IOException("Failing split. Expected reference file count isn't equal.");
        }
    }

    private Pair<Path, Path> splitStoreFile(HRegionFileSystem regionFs, byte[] family, HStoreFile sf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pid=" + this.getProcId() + " splitting started for store file: " + sf.getPath() + " for region: " + this.getParentRegion().getShortNameToLog());
        }
        byte[] splitRow = this.getSplitRow();
        String familyName = Bytes.toString((byte[])family);
        Path path_first = regionFs.splitStoreFile(this.daughter_1_RI, familyName, sf, splitRow, false, this.splitPolicy);
        Path path_second = regionFs.splitStoreFile(this.daughter_2_RI, familyName, sf, splitRow, true, this.splitPolicy);
        if (LOG.isDebugEnabled()) {
            LOG.debug("pid=" + this.getProcId() + " splitting complete for store file: " + sf.getPath() + " for region: " + this.getParentRegion().getShortNameToLog());
        }
        return new Pair((Object)path_first, (Object)path_second);
    }

    private void preSplitRegionBeforeMETA(MasterProcedureEnv env) throws IOException, InterruptedException {
        ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitBeforeMETAAction(this.getSplitRow(), metaEntries, this.getUser());
            try {
                for (Mutation p : metaEntries) {
                    RegionInfo.parseRegionName((byte[])p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error("pid=" + this.getProcId() + " row key of mutation from coprocessor not parsable as " + "region name." + "Mutations from coprocessor should only for hbase:meta table.");
                throw e;
            }
        }
    }

    private void updateMeta(MasterProcedureEnv env) throws IOException {
        env.getAssignmentManager().markRegionAsSplit(this.getParentRegion(), this.getParentRegionServerName(env), this.daughter_1_RI, this.daughter_2_RI);
    }

    private void preSplitRegionAfterMETA(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitAfterMETAAction(this.getUser());
        }
    }

    private void postSplitRegion(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postCompletedSplitRegionAction(this.daughter_1_RI, this.daughter_2_RI, this.getUser());
        }
    }

    private ServerName getParentRegionServerName(MasterProcedureEnv env) {
        return env.getMasterServices().getAssignmentManager().getRegionStates().getRegionServerOfRegion(this.getParentRegion());
    }

    private TransitRegionStateProcedure[] createUnassignProcedures(MasterProcedureEnv env) throws IOException {
        return AssignmentManagerUtil.createUnassignProceduresForSplitOrMerge(env, Stream.of(this.getParentRegion()), this.getRegionReplication(env));
    }

    private TransitRegionStateProcedure[] createAssignProcedures(MasterProcedureEnv env) throws IOException {
        ArrayList<RegionInfo> hris = new ArrayList<RegionInfo>(2);
        hris.add(this.daughter_1_RI);
        hris.add(this.daughter_2_RI);
        return AssignmentManagerUtil.createAssignProceduresForOpeningNewRegions(env, hris, this.getRegionReplication(env), this.getParentRegionServerName(env));
    }

    private int getRegionReplication(MasterProcedureEnv env) throws IOException {
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        return htd.getRegionReplication();
    }

    private void writeMaxSequenceIdFile(MasterProcedureEnv env) throws IOException {
        MasterFileSystem fs = env.getMasterFileSystem();
        long maxSequenceId = WALSplitUtil.getMaxRegionSequenceId(env.getMasterConfiguration(), this.getParentRegion(), (ConcurrentMapUtils.IOExceptionSupplier<FileSystem>)((ConcurrentMapUtils.IOExceptionSupplier)fs::getFileSystem), (ConcurrentMapUtils.IOExceptionSupplier<FileSystem>)((ConcurrentMapUtils.IOExceptionSupplier)fs::getWALFileSystem));
        if (maxSequenceId > 0L) {
            WALSplitUtil.writeRegionSequenceIdFile(fs.getWALFileSystem(), this.getWALRegionDir(env, this.daughter_1_RI), maxSequenceId);
            WALSplitUtil.writeRegionSequenceIdFile(fs.getWALFileSystem(), this.getWALRegionDir(env, this.daughter_2_RI), maxSequenceId);
        }
    }

    protected boolean abort(MasterProcedureEnv env) {
        return this.isRollbackSupported((MasterProcedureProtos.SplitTableRegionState)this.getCurrentState()) ? super.abort((Object)env) : false;
    }

    private class StoreFileSplitter
    implements Callable<Pair<Path, Path>> {
        private final HRegionFileSystem regionFs;
        private final byte[] family;
        private final HStoreFile sf;

        public StoreFileSplitter(HRegionFileSystem regionFs, byte[] family, HStoreFile sf) {
            this.regionFs = regionFs;
            this.sf = sf;
            this.family = family;
        }

        @Override
        public Pair<Path, Path> call() throws IOException {
            return SplitTableRegionProcedure.this.splitStoreFile(this.regionFs, this.family, this.sf);
        }
    }
}

