/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DecommissionCandidateNodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DecommissionCandidates;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NewNMCandidates;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NewSingleTypeNMCandidate;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInstanceType;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInstanceTypeList;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;

@XmlRootElement(name="clusterScaling")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ClusterScalingInfo {
    private static final Log LOG = LogFactory.getLog((String)ClusterScalingInfo.class.getName());
    @XmlElement
    public String apiVersion = "v1";
    @XmlElement
    public String consideredResourceTypes;
    @XmlElement
    public NodeInstanceTypeList nodeInstanceTypeList;
    @XmlElement
    public NewNMCandidates newNMCandidates = new NewNMCandidates();
    @XmlElement
    public DecommissionCandidates decommissionCandidates = new DecommissionCandidates();

    public ClusterScalingInfo() {
    }

    public ClusterScalingInfo(ResourceManager rm, String resourceTypes, int downscalingFactorInNodeCount, NodeInstanceTypeList niTypeList) {
        this(rm, rm.getResourceScheduler(), resourceTypes, downscalingFactorInNodeCount, niTypeList);
    }

    public ClusterScalingInfo(ResourceManager rm, ResourceScheduler rs, String resTypes, int downscalingFactorInNodeCount, NodeInstanceTypeList niTypeList) {
        if (rs == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        if (!(rs instanceof CapacityScheduler)) {
            throw new BadRequestException("Only Capacity Scheduler is supported!");
        }
        this.nodeInstanceTypeList = niTypeList;
        this.consideredResourceTypes = resTypes == null ? "memory-mb" : resTypes;
        QueueMetrics metrics = rs.getRootQueueMetrics();
        int pendingAppCount = metrics.getAppsPending();
        int pendingContainersCount = metrics.getPendingContainers();
        List<FiCaSchedulerNode> rmNodes = ((CapacityScheduler)rs).getAllNodes();
        if (rmNodes.size() == 0) {
            return;
        }
        ClusterScalingInfo.recommendDownscaling(rmNodes, this.decommissionCandidates, downscalingFactorInNodeCount);
        ClusterScalingInfo.recommendUpscaling(pendingAppCount, pendingContainersCount, metrics.getContainerAskToCount(), this.consideredResourceTypes, this.nodeInstanceTypeList, this.newNMCandidates);
    }

    public static void recommendDownscaling(List<FiCaSchedulerNode> rmNodes, DecommissionCandidates decommissionCandidates, int downscalingFactorInNodeCount) {
        boolean upToEngine = false;
        if (downscalingFactorInNodeCount == 0) {
            return;
        }
        if (downscalingFactorInNodeCount <= 0) {
            upToEngine = true;
        }
        HashMap<RMNode, Integer> nodeToDecommissionTimeout = new HashMap<RMNode, Integer>();
        HashMap<RMNode, Integer> nodeToAMCount = new HashMap<RMNode, Integer>();
        HashMap<RMNode, Integer> nodeToRunningAppCount = new HashMap<RMNode, Integer>();
        for (FiCaSchedulerNode node : rmNodes) {
            RMNode rmNode = node.getRMNode();
            Integer deTimeout = rmNode.getDecommissioningTimeout();
            if (deTimeout == null) {
                deTimeout = -1;
            }
            if (deTimeout > 0 && rmNode.getState() != NodeState.DECOMMISSIONING) {
                deTimeout = -1;
            }
            nodeToDecommissionTimeout.put(rmNode, deTimeout);
            int amCount = 0;
            for (RMContainer rmContainer : node.getCopiedListOfRunningContainers()) {
                if (!rmContainer.isAMContainer()) continue;
                ++amCount;
            }
            nodeToAMCount.put(rmNode, amCount);
            nodeToRunningAppCount.put(rmNode, node.getRMNode().getRunningApps().size());
        }
        DownscalingNodeComparator comparator = new DownscalingNodeComparator(nodeToDecommissionTimeout, nodeToAMCount, nodeToRunningAppCount);
        TreeSet<RMNode> sortedNodes = new TreeSet<RMNode>(comparator);
        for (FiCaSchedulerNode node : rmNodes) {
            RMNode rmNode = node.getRMNode();
            sortedNodes.add(rmNode);
        }
        int neededCount = downscalingFactorInNodeCount;
        int foundCount = 0;
        if (downscalingFactorInNodeCount > rmNodes.size()) {
            LOG.warn((Object)"Requested downscaling candidates count is larger thancluster node count!");
            neededCount = rmNodes.size();
        }
        for (RMNode node : sortedNodes) {
            int amCount = nodeToAMCount.get(node);
            int runningAppCount = nodeToRunningAppCount.get(node);
            boolean recommendFlag = ClusterScalingInfo.getDownscalingRecommendFlag(amCount, runningAppCount, node.getState());
            DecommissionCandidateNodeInfo dcni = new DecommissionCandidateNodeInfo(nodeToAMCount.get(node), nodeToRunningAppCount.get(node), nodeToDecommissionTimeout.get(node), node.getState(), node.getNodeID().toString(), recommendFlag);
            if (upToEngine) {
                if (!recommendFlag) continue;
                decommissionCandidates.add(dcni);
                continue;
            }
            decommissionCandidates.add(dcni);
            if (++foundCount != neededCount) continue;
            return;
        }
    }

    public static boolean getDownscalingRecommendFlag(int amCount, int runningAppCount, NodeState state) {
        if (state == NodeState.LOST || state == NodeState.UNHEALTHY || state == NodeState.REBOOTED) {
            return true;
        }
        return state == NodeState.RUNNING && amCount == 0 && runningAppCount == 0;
    }

    public static void recommendUpscaling(int pendingAppCount, int pendingContainersCount, Map<Resource, Integer> containerAskToCount, String resourceTypes, NodeInstanceTypeList nodeInstanceTypeList, NewNMCandidates newNMCandidates) {
        if (pendingAppCount > 0 || pendingContainersCount > 0) {
            ResourceCalculator rc = ClusterScalingInfo.chooseResCalculator(resourceTypes);
            ClusterScalingInfo.recommendNewInstances(containerAskToCount, newNMCandidates, nodeInstanceTypeList.getInstanceTypes(), rc);
        }
    }

    public static ResourceCalculator chooseResCalculator(String resourceTypes) {
        String lowerCaseRes = resourceTypes.toLowerCase();
        if (lowerCaseRes.isEmpty()) {
            return new DefaultResourceCalculator();
        }
        String[] types = lowerCaseRes.split(",");
        if (types == null) {
            return new DefaultResourceCalculator();
        }
        if (types.length > 1) {
            return new DominantResourceCalculator();
        }
        return new DefaultResourceCalculator();
    }

    public static void recommendNewInstances(Map<Resource, Integer> pendingContainers, NewNMCandidates newNMCandidates, List<NodeInstanceType> allTypes, ResourceCalculator rc) {
        int[] suitableInstanceRet = null;
        StringBuilder tip = new StringBuilder();
        for (Map.Entry<Resource, Integer> entry : pendingContainers.entrySet()) {
            ClusterScalingInfo.scheduleBasedOnRecommendedNewInstance(entry.getKey(), entry.getValue(), newNMCandidates, entry, rc);
            if (entry.getValue() == 0) continue;
            suitableInstanceRet = NodeInstanceType.getSuitableInstanceType(entry.getKey(), allTypes, rc);
            int ti = suitableInstanceRet[0];
            if (ti == -1) {
                tip.append(String.format("No capable instance type for container resource: %s, count: %d", entry.getKey(), entry.getValue()));
                continue;
            }
            Resource containerResource = entry.getKey();
            int containerCount = entry.getValue();
            NodeInstanceType t = allTypes.get(ti);
            int buckets = suitableInstanceRet[1];
            int instanceCount = (int)Math.ceil((double)containerCount / (double)buckets);
            Resource planToUseResourceInThisNodeType = Resources.multiplyAndRoundUp((Resource)containerResource, (double)containerCount);
            newNMCandidates.add(t, instanceCount, planToUseResourceInThisNodeType);
            newNMCandidates.setRecommendActionTime("Now");
        }
    }

    public static void scheduleBasedOnRecommendedNewInstance(Resource containerRes, int count, NewNMCandidates newNMCandidates, Map.Entry<Resource, Integer> entry, ResourceCalculator rc) {
        for (NewSingleTypeNMCandidate singleTypeNMCandidate : newNMCandidates.getCandidates()) {
            Resource headroom = singleTypeNMCandidate.getPlanRemaining().getResource();
            Resource headroomInEveryNode = rc.divideAndCeil(headroom, singleTypeNMCandidate.getCount());
            long bucketsInExistingOneNode = rc.computeAvailableContainers(headroomInEveryNode, containerRes);
            if (bucketsInExistingOneNode > 0L) {
                int prev = count;
                if ((count = (int)((long)count - bucketsInExistingOneNode)) < 0) {
                    count = 0;
                }
                entry.setValue(count);
                singleTypeNMCandidate.addPlanToUse(Resources.multiplyAndRoundUp((Resource)containerRes, (double)prev));
                continue;
            }
            return;
        }
    }

    public DecommissionCandidates getDecommissionCandidates() {
        return this.decommissionCandidates;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public NewNMCandidates getNewNMCandidates() {
        return this.newNMCandidates;
    }

    public String getConsideredResourceTypes() {
        return this.consideredResourceTypes;
    }

    public static class DownscalingNodeComparator
    implements Comparator<RMNode> {
        HashMap<RMNode, Integer> nodeToDecommissionTimeout;
        HashMap<RMNode, Integer> nodeToAMCount;
        HashMap<RMNode, Integer> nodeToRunningAppCount;

        public DownscalingNodeComparator(HashMap<RMNode, Integer> nToD, HashMap<RMNode, Integer> nToAM, HashMap<RMNode, Integer> nToR) {
            this.nodeToDecommissionTimeout = nToD;
            this.nodeToAMCount = nToAM;
            this.nodeToRunningAppCount = nToR;
        }

        @Override
        public int compare(RMNode o1, RMNode o2) {
            int appCount2;
            int amCount2;
            if (o1.getState() != o2.getState()) {
                return this.scoreStatus(o1) > this.scoreStatus(o2) ? -1 : 1;
            }
            int timeout1 = this.nodeToDecommissionTimeout.get(o1);
            timeout1 = timeout1 == -1 ? Integer.MAX_VALUE : timeout1;
            int timeout2 = this.nodeToDecommissionTimeout.get(o2);
            int n = timeout2 = timeout2 == -1 ? Integer.MAX_VALUE : timeout2;
            if (timeout1 != timeout2) {
                return timeout1 > timeout2 ? 1 : -1;
            }
            int amCount1 = this.nodeToAMCount.get(o1);
            if (amCount1 != (amCount2 = this.nodeToAMCount.get(o2).intValue())) {
                return amCount1 > amCount2 ? 1 : -1;
            }
            int appCount1 = this.nodeToRunningAppCount.get(o1);
            if (appCount1 != (appCount2 = this.nodeToRunningAppCount.get(o2).intValue())) {
                return appCount1 > appCount2 ? 1 : -1;
            }
            return o1.getNodeID().compareTo(o2.getNodeID());
        }

        private int scoreStatus(RMNode node) {
            switch (node.getState()) {
                case LOST: {
                    return 10;
                }
                case UNHEALTHY: {
                    return 9;
                }
                case REBOOTED: {
                    return 8;
                }
                case RUNNING: {
                    return 7;
                }
                case NEW: {
                    return 6;
                }
                case DECOMMISSIONING: {
                    return 5;
                }
                case DECOMMISSIONED: {
                    return 4;
                }
            }
            return 0;
        }
    }
}

