/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSharePolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "fair";
    private static final Log LOG = LogFactory.getLog(FairSharePolicy.class);
    private static final String MEMORY = ResourceInformation.MEMORY_MB.getName();
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private static final FairShareComparator COMPARATOR = new FairShareComparator();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        return COMPARATOR;
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return RESOURCE_CALCULATOR;
    }

    @Override
    public Resource getHeadroom(Resource queueFairShare, Resource queueUsage, Resource maxAvailable) {
        long queueAvailableMemory = Math.max(queueFairShare.getMemorySize() - queueUsage.getMemorySize(), 0L);
        Resource headroom = Resources.createResource((long)Math.min(maxAvailable.getMemorySize(), queueAvailableMemory), (int)maxAvailable.getVirtualCores());
        return headroom;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        ComputeFairShares.computeShares(schedulables, totalResources, MEMORY);
    }

    @Override
    public void computeSteadyShares(Collection<? extends FSQueue> queues, Resource totalResources) {
        ComputeFairShares.computeSteadyShares(queues, totalResources, MEMORY);
    }

    @Override
    public boolean checkIfUsageOverFairShare(Resource usage, Resource fairShare) {
        return usage.getMemorySize() > fairShare.getMemorySize();
    }

    @Override
    public boolean isChildPolicyAllowed(SchedulingPolicy childPolicy) {
        if (childPolicy instanceof DominantResourceFairnessPolicy) {
            LOG.error((Object)("Queue policy can't be DRF if the parent policy is " + this.getName() + ". Choose " + this.getName() + " or " + "FIFO" + " for child queues instead." + " Please note that " + "FIFO" + " is only for leaf queues."));
            return false;
        }
        return true;
    }

    private static class FairShareComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = 5564969375856699313L;

        private FairShareComparator() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            int res = this.compareDemand(s1, s2);
            Resource resourceUsage1 = null;
            Resource resourceUsage2 = null;
            if (res == 0) {
                resourceUsage1 = s1.getResourceUsage();
                resourceUsage2 = s2.getResourceUsage();
                res = this.compareMinShareUsage(s1, s2, resourceUsage1, resourceUsage2);
            }
            if (res == 0) {
                res = this.compareFairShareUsage(s1, s2, resourceUsage1, resourceUsage2);
            }
            if (res == 0) {
                res = (int)Math.signum(s1.getStartTime() - s2.getStartTime());
            }
            if (res == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }

        private int compareDemand(Schedulable s1, Schedulable s2) {
            int res = 0;
            long demand1 = s1.getDemand().getMemorySize();
            long demand2 = s2.getDemand().getMemorySize();
            if (demand1 == 0L && demand2 > 0L) {
                res = 1;
            } else if (demand2 == 0L && demand1 > 0L) {
                res = -1;
            }
            return res;
        }

        private int compareMinShareUsage(Schedulable s1, Schedulable s2, Resource resourceUsage1, Resource resourceUsage2) {
            int res;
            boolean s2Needy;
            long minShare1 = Math.min(s1.getMinShare().getMemorySize(), s1.getDemand().getMemorySize());
            long minShare2 = Math.min(s2.getMinShare().getMemorySize(), s2.getDemand().getMemorySize());
            boolean s1Needy = resourceUsage1.getMemorySize() < minShare1;
            boolean bl = s2Needy = resourceUsage2.getMemorySize() < minShare2;
            if (s1Needy && !s2Needy) {
                res = -1;
            } else if (s2Needy && !s1Needy) {
                res = 1;
            } else if (s1Needy && s2Needy) {
                double minShareRatio1 = resourceUsage1.getMemorySize();
                double minShareRatio2 = resourceUsage2.getMemorySize();
                if (minShare1 > 1L) {
                    minShareRatio1 /= (double)minShare1;
                }
                if (minShare2 > 1L) {
                    minShareRatio2 /= (double)minShare2;
                }
                res = (int)Math.signum(minShareRatio1 - minShareRatio2);
            } else {
                res = 0;
            }
            return res;
        }

        private int compareFairShareUsage(Schedulable s1, Schedulable s2, Resource resourceUsage1, Resource resourceUsage2) {
            double useToWeightRatio2;
            double useToWeightRatio1;
            double weight1 = s1.getWeight();
            double weight2 = s2.getWeight();
            if (weight1 > 0.0 && weight2 > 0.0) {
                useToWeightRatio1 = (double)resourceUsage1.getMemorySize() / weight1;
                useToWeightRatio2 = (double)resourceUsage2.getMemorySize() / weight2;
            } else if (weight1 == weight2) {
                useToWeightRatio1 = resourceUsage1.getMemorySize();
                useToWeightRatio2 = resourceUsage2.getMemorySize();
            } else {
                useToWeightRatio1 = -weight1;
                useToWeightRatio2 = -weight2;
            }
            return (int)Math.signum(useToWeightRatio1 - useToWeightRatio2);
        }
    }
}

