/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DryRunResultHolder {
    private static final Logger LOG = LoggerFactory.getLogger(DryRunResultHolder.class);
    private Set<String> warnings = new HashSet<String>();
    private Set<String> errors = new HashSet<String>();
    private boolean verificationFailed;

    public void addDryRunWarning(String message) {
        this.warnings.add(message);
    }

    public void addDryRunError(String message) {
        this.errors.add(message);
    }

    public void setVerificationFailed() {
        this.verificationFailed = true;
    }

    public Set<String> getWarnings() {
        return ImmutableSet.copyOf(this.warnings);
    }

    public Set<String> getErrors() {
        return ImmutableSet.copyOf(this.errors);
    }

    public void printDryRunResults() {
        LOG.info("");
        LOG.info("Results of dry run:");
        LOG.info("");
        int noOfErrors = this.errors.size();
        int noOfWarnings = this.warnings.size();
        LOG.info("Number of errors: {}", (Object)noOfErrors);
        LOG.info("Number of warnings: {}", (Object)noOfWarnings);
        LOG.info("Verification result: {}", (Object)(this.verificationFailed ? "FAILED" : "PASSED"));
        if (noOfErrors > 0) {
            LOG.info("");
            LOG.info("List of errors:");
            this.errors.forEach(s -> LOG.info(s));
        }
        if (noOfWarnings > 0) {
            LOG.info("");
            LOG.info("List of warnings:");
            this.warnings.forEach(s -> LOG.info(s));
        }
    }
}

