/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfigurableResource {
    private final Resource resource;
    private final double[] percentages;

    ConfigurableResource() {
        this(ConfigurableResource.getOneHundredPercentArray());
    }

    ConfigurableResource(double[] percentages) {
        this.percentages = (double[])percentages.clone();
        this.resource = null;
    }

    ConfigurableResource(long value) {
        this(Resource.newInstance((long)value));
    }

    public ConfigurableResource(Resource resource) {
        this.percentages = null;
        this.resource = resource;
    }

    private static double[] getOneHundredPercentArray() {
        double[] resourcePercentages = new double[ResourceUtils.getNumberOfKnownResourceTypes()];
        Arrays.fill(resourcePercentages, 1.0);
        return resourcePercentages;
    }

    public Resource getResource(Resource clusterResource) {
        if (this.percentages != null && clusterResource != null) {
            long memory = (long)((double)clusterResource.getMemorySize() * this.percentages[0]);
            int vcore = (int)((double)clusterResource.getVirtualCores() * this.percentages[1]);
            Resource res = Resource.newInstance((long)memory, (int)vcore);
            ResourceInformation[] clusterInfo = clusterResource.getResources();
            for (int i = 2; i < clusterInfo.length; ++i) {
                res.setResourceValue(i, (long)((double)clusterInfo[i].getValue() * this.percentages[i]));
            }
            return res;
        }
        return this.resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    void setValue(String name, long value) {
        if (this.resource != null) {
            this.resource.setResourceValue(name, value);
        }
    }

    void setPercentage(String name, double value) {
        if (this.percentages != null) {
            Integer index = (Integer)ResourceUtils.getResourceTypeIndex().get(name);
            if (index != null) {
                this.percentages[index.intValue()] = value;
            } else {
                throw new ResourceNotFoundException("The requested resource, \"" + name + "\", could not be found.");
            }
        }
    }

    public double[] getPercentages() {
        return this.percentages == null ? null : Arrays.copyOf(this.percentages, this.percentages.length);
    }
}

