/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor;

import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.AbstractPlacementProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerPlacementProcessor
extends AbstractPlacementProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerPlacementProcessor.class);

    public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
        if (request.getSchedulingRequests() != null && !request.getSchedulingRequests().isEmpty() && !(this.scheduler instanceof CapacityScheduler)) {
            String message = "Found non empty SchedulingRequest of AllocateRequest for application=" + appAttemptId.toString() + ", however the configured scheduler=" + this.scheduler.getClass().getCanonicalName() + " cannot handle placement constraints, rejecting this " + "allocate operation";
            LOG.warn(message);
            throw new YarnException(message);
        }
        this.nextAMSProcessor.allocate(appAttemptId, request, response);
    }
}

