/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMappingEntity;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePlacementRuleUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;

public class AppNameMappingPlacementRule
extends PlacementRule {
    private static final Log LOG = LogFactory.getLog(AppNameMappingPlacementRule.class);
    public static final String CURRENT_APP_MAPPING = "%application";
    private static final String QUEUE_MAPPING_NAME = "app-name";
    private boolean overrideWithQueueMappings = false;
    private List<QueueMappingEntity> mappings = null;

    public AppNameMappingPlacementRule() {
        this(false, null);
    }

    public AppNameMappingPlacementRule(boolean overrideWithQueueMappings, List<QueueMappingEntity> newMappings) {
        this.overrideWithQueueMappings = overrideWithQueueMappings;
        this.mappings = newMappings;
    }

    @Override
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        if (!(scheduler instanceof CapacityScheduler)) {
            throw new IOException("AppNameMappingPlacementRule can be configured only for CapacityScheduler");
        }
        CapacitySchedulerContext schedulerContext = (CapacitySchedulerContext)((Object)scheduler);
        CapacitySchedulerConfiguration conf = schedulerContext.getConfiguration();
        boolean overrideWithQueueMappings = conf.getOverrideWithQueueMappings();
        LOG.info((Object)("Initialized App Name queue mappings, override: " + overrideWithQueueMappings));
        List<QueueMappingEntity> queueMappings = conf.getQueueMappingEntity(QUEUE_MAPPING_NAME);
        ArrayList<QueueMappingEntity> newMappings = new ArrayList<QueueMappingEntity>();
        CapacitySchedulerQueueManager queueManager = schedulerContext.getCapacitySchedulerQueueManager();
        for (QueueMappingEntity mapping : queueMappings) {
            QueuePath queuePath = QueuePlacementRuleUtils.extractQueuePath(mapping.getQueue());
            if (QueuePlacementRuleUtils.isStaticQueueMapping(mapping)) {
                QueueMappingEntity newMapping;
                CSQueue queue = queueManager.getQueue(mapping.getQueue());
                if (AppNameMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                    queue = queueManager.getQueue(queuePath.getLeafQueue());
                    if (AppNameMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                        newMapping = QueuePlacementRuleUtils.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
                        if (newMapping == null) {
                            throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
                        }
                        newMappings.add(newMapping);
                        continue;
                    }
                    newMapping = QueuePlacementRuleUtils.validateAndGetQueueMapping(queueManager, queue, mapping, queuePath);
                    newMappings.add(newMapping);
                    continue;
                }
                newMapping = QueuePlacementRuleUtils.validateAndGetQueueMapping(queueManager, queue, mapping, queuePath);
                newMappings.add(newMapping);
                continue;
            }
            QueueMappingEntity newMapping = QueuePlacementRuleUtils.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping != null) {
                newMappings.add(newMapping);
                continue;
            }
            newMappings.add(mapping);
        }
        if (newMappings.size() > 0) {
            this.mappings = newMappings;
            this.overrideWithQueueMappings = overrideWithQueueMappings;
            LOG.info((Object)("get valid queue mapping from app name config: " + ((Object)newMappings).toString() + ", override: " + overrideWithQueueMappings));
            return true;
        }
        return false;
    }

    private static boolean ifQueueDoesNotExist(CSQueue queue) {
        return queue == null;
    }

    private ApplicationPlacementContext getAppPlacementContext(String user, String applicationName) throws IOException {
        for (QueueMappingEntity mapping : this.mappings) {
            if (mapping.getSource().equals(CURRENT_APP_MAPPING)) {
                if (mapping.getQueue().equals(CURRENT_APP_MAPPING)) {
                    return QueuePlacementRuleUtils.getPlacementContext(mapping, applicationName);
                }
                return QueuePlacementRuleUtils.getPlacementContext(mapping);
            }
            if (!mapping.getSource().equals(applicationName)) continue;
            return QueuePlacementRuleUtils.getPlacementContext(mapping);
        }
        return null;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName = asc.getQueue();
        String applicationName = asc.getApplicationName();
        if (this.mappings != null && this.mappings.size() > 0) {
            try {
                ApplicationPlacementContext mappedQueue = this.getAppPlacementContext(user, applicationName);
                if (mappedQueue != null && (queueName.equals("default") || queueName.equals(mappedQueue.getQueue()) || this.overrideWithQueueMappings)) {
                    LOG.info((Object)("Application " + applicationName + " mapping [" + queueName + "] to [" + mappedQueue + "] override " + this.overrideWithQueueMappings));
                    return mappedQueue;
                }
            }
            catch (IOException ioex) {
                String message = "Failed to submit application " + applicationName + " reason: " + ioex.getMessage();
                throw new YarnException(message);
            }
        }
        return null;
    }
}

