/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.util.timeline;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.timeline.security.TimelineDelgationTokenSecretManagerService;

public final class TimelineServerUtils {
    private static final Log LOG = LogFactory.getLog(TimelineServerUtils.class);

    private TimelineServerUtils() {
    }

    public static void setTimelineFilters(Configuration conf, String configuredInitializers, Set<String> defaultInitializers) {
        LinkedHashSet<String> ignoreInitializers = new LinkedHashSet<String>();
        ignoreInitializers.add(AuthenticationFilterInitializer.class.getName());
        ignoreInitializers.add(ProxyUserAuthenticationFilterInitializer.class.getName());
        String[] parts = configuredInitializers.split(",");
        LinkedHashSet<String> target = new LinkedHashSet<String>();
        for (String filterInitializer : parts) {
            if (ignoreInitializers.contains(filterInitializer = filterInitializer.trim()) || filterInitializer.isEmpty()) continue;
            target.add(filterInitializer);
        }
        target.addAll(defaultInitializers);
        String actualInitializers = StringUtils.join(target, (String)",");
        LOG.info((Object)("Filter initializers set for timeline service: " + actualInitializers));
        conf.set("hadoop.http.filter.initializers", actualInitializers);
    }

    public static void addTimelineAuthFilter(String initializers, Set<String> defaultInitializers, TimelineDelgationTokenSecretManagerService delegationTokenMgrService) {
        TimelineAuthenticationFilter.setTimelineDelegationTokenSecretManager(delegationTokenMgrService.getTimelineDelegationTokenSecretManager());
        if (!initializers.contains(TimelineAuthenticationFilterInitializer.class.getName())) {
            defaultInitializers.add(TimelineAuthenticationFilterInitializer.class.getName());
        }
    }
}

