/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUserAuthenticationFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUserAuthenticationFilter.class);
    private static final String DO_AS = "doAs";
    public static final String PROXYUSER_PREFIX = "proxyuser";

    public void init(FilterConfig filterConfig) throws ServletException {
        Configuration conf = this.getProxyuserConfiguration(filterConfig);
        ProxyUsers.refreshSuperUserGroupsConfiguration(conf, PROXYUSER_PREFIX);
        super.init(filterConfig);
    }

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String doAsUser = request.getParameter(DO_AS);
        if (doAsUser != null && !doAsUser.equals(request.getRemoteUser())) {
            UserGroupInformation requestUgi;
            LOG.debug("doAsUser = {}, RemoteUser = {} , RemoteAddress = {} ", new Object[]{doAsUser, request.getRemoteUser(), request.getRemoteAddr()});
            UserGroupInformation userGroupInformation = requestUgi = request.getUserPrincipal() != null ? UserGroupInformation.createRemoteUser(request.getRemoteUser()) : null;
            if (requestUgi != null) {
                requestUgi = UserGroupInformation.createProxyUser(doAsUser, requestUgi);
                try {
                    ProxyUsers.authorize(requestUgi, request.getRemoteAddr());
                    final UserGroupInformation ugiF = requestUgi;
                    request = new HttpServletRequestWrapper((HttpServletRequest)request){

                        public String getRemoteUser() {
                            return ugiF.getShortUserName();
                        }

                        public Principal getUserPrincipal() {
                            return new Principal(){

                                @Override
                                public String getName() {
                                    return ugiF.getUserName();
                                }
                            };
                        }
                    };
                    LOG.debug("Proxy user Authentication successful");
                }
                catch (AuthorizationException ex) {
                    HttpExceptionUtils.createServletExceptionResponse(response, 403, ex);
                    LOG.warn("Proxy user Authentication exception", (Throwable)ex);
                    return;
                }
            }
        }
        super.doFilter(filterChain, request, response);
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) throws ServletException {
        Configuration conf = new Configuration(false);
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("proxyuser.")) continue;
            String value = filterConfig.getInitParameter(name);
            conf.set(name, value);
        }
        return conf;
    }
}

