/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomTokenProviderAdapter
extends AccessTokenProvider
implements BoundDTExtension {
    private CustomTokenProviderAdaptee adaptee;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public CustomTokenProviderAdapter(CustomTokenProviderAdaptee adaptee) {
        Preconditions.checkNotNull((Object)adaptee, (Object)"adaptee");
        this.adaptee = adaptee;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing custom based token");
        AzureADToken azureADToken = new AzureADToken();
        azureADToken.setAccessToken(this.adaptee.getAccessToken());
        azureADToken.setExpiry(this.adaptee.getExpiryTime());
        return azureADToken;
    }

    @Override
    public void bind(URI fsURI, Configuration conf) throws IOException {
        ExtensionHelper.bind(this.adaptee, fsURI, conf);
    }

    @Override
    public void close() {
        ExtensionHelper.close(this.adaptee);
    }

    @Override
    public String getUserAgentSuffix() {
        String suffix = ExtensionHelper.getUserAgentSuffix(this.adaptee, "");
        return suffix != null ? suffix : "";
    }
}

