/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.fs.azurebfs.oauth2.QueryParams;
import org.apache.hadoop.fs.azurebfs.services.AbfsIoUtils;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class AzureADAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(AzureADAuthenticator.class);
    private static final String RESOURCE_NAME = "https://storage.azure.com/";
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;

    private AzureADAuthenticator() {
    }

    public static AzureADToken getTokenUsingClientCreds(String authEndpoint, String clientId, String clientSecret) throws IOException {
        Preconditions.checkNotNull((Object)authEndpoint, (Object)"authEndpoint");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId");
        Preconditions.checkNotNull((Object)clientSecret, (Object)"clientSecret");
        QueryParams qp = new QueryParams();
        qp.add("resource", RESOURCE_NAME);
        qp.add("grant_type", "client_credentials");
        qp.add("client_id", clientId);
        qp.add("client_secret", clientSecret);
        LOG.debug("AADToken: starting to fetch token using client creds for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), null, null);
    }

    public static AzureADToken getTokenFromMsi(String authEndpoint, String tenantGuid, String clientId, String authority, boolean bypassCache) throws IOException {
        QueryParams qp = new QueryParams();
        qp.add("api-version", "2018-02-01");
        qp.add("resource", RESOURCE_NAME);
        if (tenantGuid != null && tenantGuid.length() > 0) {
            authority = authority + tenantGuid;
            LOG.debug("MSI authority : {}", (Object)authority);
            qp.add("authority", authority);
        }
        if (clientId != null && clientId.length() > 0) {
            qp.add("client_id", clientId);
        }
        if (bypassCache) {
            qp.add("bypass_cache", "true");
        }
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Metadata", "true");
        LOG.debug("AADToken: starting to fetch token using MSI");
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), headers, "GET");
    }

    public static AzureADToken getTokenUsingRefreshToken(String authEndpoint, String clientId, String refreshToken) throws IOException {
        QueryParams qp = new QueryParams();
        qp.add("grant_type", "refresh_token");
        qp.add("refresh_token", refreshToken);
        if (clientId != null) {
            qp.add("client_id", clientId);
        }
        LOG.debug("AADToken: starting to fetch token using refresh token for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), null, null);
    }

    private static AzureADToken getTokenCall(String authEndpoint, String body, Hashtable<String, String> headers, String httpMethod) throws IOException {
        AzureADToken token = null;
        ExponentialRetryPolicy retryPolicy = new ExponentialRetryPolicy(3, 0, 1000, 2);
        int httperror = 0;
        IOException ex = null;
        boolean succeeded = false;
        int retryCount = 0;
        do {
            httperror = 0;
            ex = null;
            try {
                token = AzureADAuthenticator.getTokenSingleCall(authEndpoint, body, headers, httpMethod);
            }
            catch (HttpException e) {
                httperror = e.httpErrorCode;
                ex = e;
            }
            catch (IOException e) {
                ex = e;
            }
        } while (!(succeeded = httperror == 0 && ex == null) && retryPolicy.shouldRetry(++retryCount, httperror));
        if (!succeeded) {
            throw ex;
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AzureADToken getTokenSingleCall(String authEndpoint, String payload, Hashtable<String, String> headers, String httpMethod) throws IOException {
        AzureADToken token;
        block12: {
            token = null;
            HttpURLConnection conn = null;
            String urlString = authEndpoint;
            String string = httpMethod = httpMethod == null ? "POST" : httpMethod;
            if (httpMethod.equals("GET")) {
                urlString = urlString + "?" + payload;
            }
            try {
                LOG.debug("Requesting an OAuth token by {} to {}", (Object)httpMethod, (Object)authEndpoint);
                URL url = new URL(urlString);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod(httpMethod);
                conn.setReadTimeout(30000);
                conn.setConnectTimeout(30000);
                if (headers != null && headers.size() > 0) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        conn.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                conn.setRequestProperty("Connection", "close");
                AbfsIoUtils.dumpHeadersToDebugLog("Request Headers", conn.getRequestProperties());
                if (httpMethod.equals("POST")) {
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(payload.getBytes("UTF-8"));
                }
                int httpResponseCode = conn.getResponseCode();
                LOG.debug("Response {}", (Object)httpResponseCode);
                AbfsIoUtils.dumpHeadersToDebugLog("Response Headers", conn.getHeaderFields());
                String requestId = conn.getHeaderField("x-ms-request-id");
                String responseContentType = conn.getHeaderField("Content-Type");
                long responseContentLength = conn.getHeaderFieldLong("Content-Length", 0L);
                String string2 = requestId = requestId == null ? "" : requestId;
                if (httpResponseCode == 200 && responseContentType.startsWith("application/json") && responseContentLength > 0L) {
                    InputStream httpResponseStream = conn.getInputStream();
                    token = AzureADAuthenticator.parseTokenFromStream(httpResponseStream);
                    break block12;
                }
                InputStream stream = conn.getErrorStream();
                if (stream == null) {
                    stream = conn.getInputStream();
                }
                String responseBody = AzureADAuthenticator.consumeInputStream(stream, 1024);
                String proxies = "none";
                String httpProxy = System.getProperty("http.proxy");
                String httpsProxy = System.getProperty("https.proxy");
                if (httpProxy != null || httpsProxy != null) {
                    proxies = "http:" + httpProxy + "; https:" + httpsProxy;
                }
                String operation = "AADToken: HTTP connection to " + authEndpoint + " failed for getting token from AzureAD.";
                String logMessage = operation + " HTTP response: " + httpResponseCode + " " + conn.getResponseMessage() + " Proxies: " + proxies + (responseBody.isEmpty() ? "" : "\nFirst 1K of Body: " + responseBody);
                LOG.debug(logMessage);
                if (httpResponseCode == 200) {
                    throw new UnexpectedResponseException(httpResponseCode, requestId, operation + " Unexpected response." + " Check configuration, URLs and proxy settings." + " proxies=" + proxies, authEndpoint, responseContentType, responseBody);
                }
                throw new HttpException(httpResponseCode, requestId, operation, authEndpoint, responseContentType, responseBody);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return token;
    }

    private static AzureADToken parseTokenFromStream(InputStream httpResponseStream) throws IOException {
        AzureADToken token = new AzureADToken();
        try {
            int expiryPeriod = 0;
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createJsonParser(httpResponseStream);
            jp.nextToken();
            while (jp.hasCurrentToken()) {
                if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    String fieldValue = jp.getText();
                    if (fieldName.equals("access_token")) {
                        token.setAccessToken(fieldValue);
                    }
                    if (fieldName.equals("expires_in")) {
                        expiryPeriod = Integer.parseInt(fieldValue);
                    }
                }
                jp.nextToken();
            }
            jp.close();
            long expiry = System.currentTimeMillis();
            token.setExpiry(new Date(expiry += (long)expiryPeriod * 1000L));
            LOG.debug("AADToken: fetched token with expiry " + token.getExpiry().toString());
        }
        catch (Exception ex) {
            LOG.debug("AADToken: got exception when parsing json token " + ex.toString());
            throw ex;
        }
        finally {
            httpResponseStream.close();
        }
        return token;
    }

    private static String consumeInputStream(InputStream inStream, int length) throws IOException {
        if (inStream == null) {
            return "";
        }
        byte[] b = new byte[length];
        int totalBytesRead = 0;
        int bytesRead = 0;
        do {
            if ((bytesRead = inStream.read(b, totalBytesRead, length - totalBytesRead)) <= 0) continue;
            totalBytesRead += bytesRead;
        } while (bytesRead >= 0 && totalBytesRead < length);
        return new String(b, 0, totalBytesRead, StandardCharsets.UTF_8);
    }

    public static class UnexpectedResponseException
    extends HttpException {
        public UnexpectedResponseException(int httpErrorCode, String requestId, String message, String url, String contentType, String body) {
            super(httpErrorCode, requestId, message, url, contentType, body);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"authorization-subsystems"})
    @InterfaceStability.Unstable
    public static class HttpException
    extends IOException {
        private final int httpErrorCode;
        private final String requestId;
        private final String url;
        private final String contentType;
        private final String body;

        public int getHttpErrorCode() {
            return this.httpErrorCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        protected HttpException(int httpErrorCode, String requestId, String message, String url, String contentType, String body) {
            super(message);
            this.httpErrorCode = httpErrorCode;
            this.requestId = requestId;
            this.url = url;
            this.contentType = contentType;
            this.body = body;
        }

        public String getUrl() {
            return this.url;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getBody() {
            return this.body;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("HTTP Error ");
            sb.append(this.httpErrorCode);
            sb.append("; url='").append(this.url).append('\'');
            sb.append(' ');
            sb.append(super.getMessage());
            sb.append("; requestId='").append(this.requestId).append('\'');
            sb.append("; contentType='").append(this.contentType).append('\'');
            sb.append("; response '").append(this.body).append('\'');
            return sb.toString();
        }
    }
}

