/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@VisibleForTesting
public final class PathMetadataDynamoDBTranslation {
    @VisibleForTesting
    static final String PARENT = "parent";
    @VisibleForTesting
    static final String CHILD = "child";
    @VisibleForTesting
    static final String IS_DIR = "is_dir";
    @VisibleForTesting
    static final String MOD_TIME = "mod_time";
    @VisibleForTesting
    static final String FILE_LENGTH = "file_length";
    @VisibleForTesting
    static final String BLOCK_SIZE = "block_size";
    static final String IS_DELETED = "is_deleted";
    static final String IS_AUTHORITATIVE = "is_authoritative";
    static final String LAST_UPDATED = "last_updated";
    static final String ETAG = "etag";
    static final String VERSION_ID = "version_id";
    @VisibleForTesting
    static final Set<String> IGNORED_FIELDS = new HashSet<String>();
    @VisibleForTesting
    static final String TABLE_VERSION = "table_version";
    @VisibleForTesting
    static final String TABLE_CREATED = "table_created";
    static final String E_NOT_VERSION_MARKER = "Not a version marker: ";

    static Collection<KeySchemaElement> keySchema() {
        return Arrays.asList(new KeySchemaElement(PARENT, KeyType.HASH), new KeySchemaElement(CHILD, KeyType.RANGE));
    }

    static Collection<AttributeDefinition> attributeDefinitions() {
        return Arrays.asList(new AttributeDefinition(PARENT, ScalarAttributeType.S), new AttributeDefinition(CHILD, ScalarAttributeType.S));
    }

    static DDBPathMetadata itemToPathMetadata(Item item, String username) {
        S3AFileStatus fileStatus;
        if (item == null) {
            return null;
        }
        String parentStr = item.getString(PARENT);
        Preconditions.checkNotNull((Object)parentStr, (String)"No parent entry in item %s", (Object)item);
        String childStr = item.getString(CHILD);
        Preconditions.checkNotNull((Object)childStr, (String)"No child entry in item %s", (Object)item);
        Path rawPath = new Path(parentStr, childStr);
        if (!rawPath.isAbsoluteAndSchemeAuthorityNull()) {
            return null;
        }
        Path parent = new Path("s3a:/" + parentStr + "/");
        Path path = new Path(parent, childStr);
        boolean isDir = item.hasAttribute(IS_DIR) && item.getBoolean(IS_DIR);
        boolean isAuthoritativeDir = false;
        long lastUpdated = 0L;
        if (isDir) {
            isAuthoritativeDir = !IGNORED_FIELDS.contains(IS_AUTHORITATIVE) && item.hasAttribute(IS_AUTHORITATIVE) && item.getBoolean(IS_AUTHORITATIVE);
            fileStatus = DynamoDBMetadataStore.makeDirStatus(path, username);
        } else {
            long len = item.hasAttribute(FILE_LENGTH) ? item.getLong(FILE_LENGTH) : 0L;
            long modTime = item.hasAttribute(MOD_TIME) ? item.getLong(MOD_TIME) : 0L;
            long block = item.hasAttribute(BLOCK_SIZE) ? item.getLong(BLOCK_SIZE) : 0L;
            String eTag = item.getString(ETAG);
            String versionId = item.getString(VERSION_ID);
            fileStatus = new S3AFileStatus(len, modTime, path, block, username, eTag, versionId);
        }
        lastUpdated = !IGNORED_FIELDS.contains(LAST_UPDATED) && item.hasAttribute(LAST_UPDATED) ? item.getLong(LAST_UPDATED) : 0L;
        boolean isDeleted = item.hasAttribute(IS_DELETED) && item.getBoolean(IS_DELETED);
        return new DDBPathMetadata(fileStatus, Tristate.UNKNOWN, isDeleted, isAuthoritativeDir, lastUpdated);
    }

    static Item pathMetadataToItem(DDBPathMetadata meta) {
        Preconditions.checkNotNull((Object)meta);
        S3AFileStatus status = meta.getFileStatus();
        Item item = new Item().withPrimaryKey(PathMetadataDynamoDBTranslation.pathToKey(status.getPath()));
        if (status.isDirectory()) {
            item.withBoolean(IS_DIR, true);
            if (!IGNORED_FIELDS.contains(IS_AUTHORITATIVE)) {
                item.withBoolean(IS_AUTHORITATIVE, meta.isAuthoritativeDir());
            }
        } else {
            item.withLong(FILE_LENGTH, status.getLen()).withLong(MOD_TIME, status.getModificationTime()).withLong(BLOCK_SIZE, status.getBlockSize());
            if (status.getETag() != null) {
                item.withString(ETAG, status.getETag());
            }
            if (status.getVersionId() != null) {
                item.withString(VERSION_ID, status.getVersionId());
            }
        }
        item.withBoolean(IS_DELETED, meta.isDeleted());
        if (!IGNORED_FIELDS.contains(LAST_UPDATED)) {
            item.withLong(LAST_UPDATED, meta.getLastUpdated());
        }
        return item;
    }

    static Item createVersionMarker(String name, int version, long timestamp) {
        return new Item().withPrimaryKey(PathMetadataDynamoDBTranslation.createVersionMarkerPrimaryKey(name)).withInt(TABLE_VERSION, version).withLong(TABLE_CREATED, timestamp);
    }

    static PrimaryKey createVersionMarkerPrimaryKey(String name) {
        return new PrimaryKey(PARENT, (Object)name, CHILD, (Object)name);
    }

    static int extractVersionFromMarker(Item marker) throws IOException {
        if (marker.hasAttribute(TABLE_VERSION)) {
            return marker.getInt(TABLE_VERSION);
        }
        throw new IOException(E_NOT_VERSION_MARKER + marker);
    }

    static Long extractCreationTimeFromMarker(Item marker) {
        if (marker.hasAttribute(TABLE_CREATED)) {
            return marker.getLong(TABLE_CREATED);
        }
        return null;
    }

    static Item[] pathMetadataToItem(Collection<DDBPathMetadata> metas) {
        if (metas == null) {
            return null;
        }
        Item[] items = new Item[metas.size()];
        int i = 0;
        for (DDBPathMetadata meta : metas) {
            items[i++] = PathMetadataDynamoDBTranslation.pathMetadataToItem(meta);
        }
        return items;
    }

    static KeyAttribute pathToParentKeyAttribute(Path path) {
        return new KeyAttribute(PARENT, (Object)PathMetadataDynamoDBTranslation.pathToParentKey(path));
    }

    @VisibleForTesting
    public static String pathToParentKey(Path path) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((boolean)path.isUriPathAbsolute(), (String)"Path not absolute: '%s'", (Object)path);
        URI uri = path.toUri();
        String bucket = uri.getHost();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)bucket) ? 1 : 0) != 0, (String)"Path missing bucket %s", (Object)path);
        String pKey = "/" + bucket + uri.getPath();
        if (pKey.endsWith("/")) {
            pKey = pKey.substring(0, pKey.length() - 1);
        }
        return pKey;
    }

    static PrimaryKey pathToKey(Path path) {
        Preconditions.checkArgument((!path.isRoot() ? 1 : 0) != 0, (Object)"Root path is not mapped to any PrimaryKey");
        String childName = path.getName();
        PrimaryKey key = new PrimaryKey(PARENT, (Object)PathMetadataDynamoDBTranslation.pathToParentKey(path.getParent()), CHILD, (Object)childName);
        for (KeyAttribute attr : key.getComponents()) {
            String name = attr.getName();
            Object v = attr.getValue();
            Preconditions.checkNotNull((Object)v, (String)"Null value for DynamoDB attribute \"%s\"", (Object)name);
            Preconditions.checkState((!((String)v).isEmpty() ? 1 : 0) != 0, (String)"Empty string value for DynamoDB attribute \"%s\"", (Object)name);
        }
        return key;
    }

    static PrimaryKey[] pathToKey(Collection<Path> paths) {
        if (paths == null) {
            return null;
        }
        PrimaryKey[] keys = new PrimaryKey[paths.size()];
        int i = 0;
        for (Path p : paths) {
            keys[i++] = PathMetadataDynamoDBTranslation.pathToKey(p);
        }
        return keys;
    }

    private PathMetadataDynamoDBTranslation() {
    }

    static List<DDBPathMetadata> pathMetaToDDBPathMeta(Collection<? extends PathMetadata> pathMetadatas) {
        return pathMetadatas.stream().map(p -> p instanceof DDBPathMetadata ? (DDBPathMetadata)p : new DDBPathMetadata((PathMetadata)p)).collect(Collectors.toList());
    }

    static String itemPrimaryKeyToString(Item item) {
        String parent = item.getString(PARENT);
        String child = item.getString(CHILD);
        return "s3a://" + parent + "/" + child;
    }

    static String primaryKeyToString(PrimaryKey item) {
        Collection c = item.getComponents();
        String parent = "";
        String child = "";
        for (KeyAttribute attr : c) {
            switch (attr.getName()) {
                case "parent": {
                    parent = attr.getValue().toString();
                    break;
                }
                case "child": {
                    child = attr.getValue().toString();
                    break;
                }
            }
        }
        return "s3a://" + parent + "/" + child;
    }

    static PathMetadata authoritativeEmptyDirectoryMarker(S3AFileStatus status) {
        return new DDBPathMetadata(status, Tristate.TRUE, false, true, 0L);
    }
}

