/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;

public abstract class AbstractDTService
extends AbstractService {
    private URI canonicalUri;
    private S3AFileSystem fileSystem;
    private UserGroupInformation owner;

    protected AbstractDTService(String name) {
        super(name);
    }

    public void bindToFileSystem(URI uri, S3AFileSystem fs) throws IOException {
        this.requireServiceState(Service.STATE.NOTINITED);
        Preconditions.checkState((this.canonicalUri == null ? 1 : 0) != 0, (Object)"bindToFileSystem called twice");
        this.canonicalUri = Objects.requireNonNull(uri);
        this.fileSystem = Objects.requireNonNull(fs);
        this.owner = fs.getOwner();
    }

    public URI getCanonicalUri() {
        return this.canonicalUri;
    }

    protected S3AFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    protected void requireServiceState(Service.STATE state) throws IllegalStateException {
        Preconditions.checkState((boolean)this.isInState(state), (String)"Required State: %s; Actual State %s", (Object)state, (Object)this.getServiceState());
    }

    protected void requireServiceStarted() throws IllegalStateException {
        this.requireServiceState(Service.STATE.STARTED);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        Objects.requireNonNull(this.canonicalUri, "service does not have a canonical URI");
    }
}

