SELECT 'Upgrading Sentry store schema from 1.5.0-cdh5-2 to 2.1.0';

CREATE TABLE "SENTRY_ROLE_USER_MAP" (
  "ROLE_ID" BIGINT NOT NULL,
  "USER_ID" BIGINT NOT NULL,
  "GRANTOR_PRINCIPAL" character varying(128)
);

ALTER TABLE "SENTRY_ROLE_USER_MAP"
  ADD CONSTRAINT "SENTRY_ROLE_USER_MAP_PK" PRIMARY KEY ("ROLE_ID","USER_ID");

ALTER TABLE ONLY "SENTRY_ROLE_USER_MAP"
  ADD CONSTRAINT "SEN_ROLE_USER_MAP_SEN_ROLE_FK"
  FOREIGN KEY ("ROLE_ID") REFERENCES "SENTRY_ROLE"("ROLE_ID") DEFERRABLE;

ALTER TABLE ONLY "SENTRY_ROLE_USER_MAP"
  ADD CONSTRAINT "SEN_ROLE_USER_MAP_SEN_USER_FK"
  FOREIGN KEY ("USER_ID") REFERENCES "SENTRY_USER"("USER_ID") DEFERRABLE;

UPDATE "SENTRY_VERSION" SET "SCHEMA_VERSION"='2.1.0', "VERSION_COMMENT"='Sentry release version 2.1.0' WHERE "VER_ID"=1;

SELECT 'Finished upgrading Sentry store schema from 1.5.0-cdh5-2 to 2.1.0';