/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hive.hcatalog.messaging.MessageDeserializer;
import org.apache.sentry.api.service.thrift.SentryMetrics;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageDeserializer;
import org.apache.sentry.provider.db.service.persistent.PathsImage;
import org.apache.sentry.service.thrift.FullUpdateInitializer;
import org.apache.sentry.service.thrift.FullUpdateModifier;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sentry.com.codahale.metrics.Counter;
import sentry.com.codahale.metrics.MetricRegistry;

public class SentryHMSClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryHMSClient.class);
    private final Configuration conf;
    private HiveMetaStoreClient client = null;
    private HiveConnectionFactory hiveConnectionFactory;
    private final Counter failedSnapshotsCount = SentryMetrics.getInstance().getCounter(MetricRegistry.name(FullUpdateInitializer.class, "failed"));

    public SentryHMSClient(Configuration conf, HiveConnectionFactory hiveConnectionFactory) {
        this.conf = conf;
        this.hiveConnectionFactory = hiveConnectionFactory;
    }

    @VisibleForTesting
    void setClient(HiveMetaStoreClient client) {
        this.client = client;
    }

    boolean isConnected() {
        return this.client != null;
    }

    public void connect() throws IOException, InterruptedException, MetaException {
        if (this.client != null) {
            return;
        }
        this.client = this.hiveConnectionFactory.connect().getClient();
    }

    public void disconnect() {
        try {
            if (this.client != null) {
                LOGGER.info("Closing the HMS client connection");
                this.client.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to close Hive Connection Factory", (Throwable)e);
        }
        finally {
            this.client = null;
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public PathsImage getFullSnapshot() throws Exception {
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to connect to HMS Server. HMS may not be up. Will try again ", (Throwable)e);
                return new PathsImage(Collections.emptyMap(), 0L, 0L);
            }
        }
        try {
            CurrentNotificationEventId eventIdBefore = this.client.getCurrentNotificationEventId();
            Map<String, Collection<String>> pathsFullSnapshot = this.fetchFullUpdate();
            if (pathsFullSnapshot.isEmpty()) {
                LOGGER.info("Received empty paths when getting full snapshot. NotificationID Before Snapshot: {}", (Object)eventIdBefore.getEventId());
                return new PathsImage(pathsFullSnapshot, 0L, 0L);
            }
            CurrentNotificationEventId eventIdAfter = this.client.getCurrentNotificationEventId();
            LOGGER.info("NotificationID, Before Snapshot: {}, After Snapshot {}", (Object)eventIdBefore.getEventId(), (Object)eventIdAfter.getEventId());
            if (eventIdAfter.equals(eventIdBefore)) {
                LOGGER.info("Successfully fetched hive full snapshot, Current NotificationID: {}.", (Object)eventIdAfter);
                return new PathsImage(pathsFullSnapshot, eventIdAfter.getEventId(), 0L);
            }
            LOGGER.info("Reconciling full snapshot - applying {} changes", (Object)(eventIdAfter.getEventId() - eventIdBefore.getEventId()));
            long currentEventId = eventIdBefore.getEventId();
            SentryJSONMessageDeserializer deserializer = new SentryJSONMessageDeserializer();
            block6: while (currentEventId < eventIdAfter.getEventId()) {
                NotificationEventResponse response = this.client.getNextNotification(currentEventId, Integer.MAX_VALUE, null);
                if (response == null || !response.isSetEvents() || response.getEvents().isEmpty()) {
                    LOGGER.error("Snapshot discarded, updates to HMS data while shapshot is being taken.ID Before: {}. ID After: {}", (Object)eventIdBefore.getEventId(), (Object)eventIdAfter.getEventId());
                    return new PathsImage(Collections.emptyMap(), 0L, 0L);
                }
                for (NotificationEvent event : response.getEvents()) {
                    LOGGER.info("Received event = {} currentEventId = {}, eventIdAfter = {}", new Object[]{event.getEventId(), currentEventId, eventIdAfter});
                    if (event.getEventId() <= eventIdBefore.getEventId()) {
                        LOGGER.error("Received stray event with eventId {} which is less then {}", (Object)event.getEventId(), (Object)eventIdBefore);
                        continue;
                    }
                    if (event.getEventId() > eventIdAfter.getEventId()) {
                        LOGGER.debug("Received eventId = {} is greater than eventIdAfter = {}", (Object)event.getEventId(), (Object)eventIdAfter);
                        continue block6;
                    }
                    try {
                        FullUpdateModifier.applyEvent(pathsFullSnapshot, event, (MessageDeserializer)deserializer);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to apply operation", (Throwable)e);
                    }
                    if (event.getEventId() != currentEventId + 1L) {
                        LOGGER.warn("Received non-sequential event. currentEventId = {} received eventId = {} ", (Object)currentEventId, (Object)event.getEventId());
                    }
                    currentEventId = event.getEventId();
                }
            }
            LOGGER.info("Successfully fetched hive full snapshot, Current NotificationID: {}.", (Object)currentEventId);
            return new PathsImage(pathsFullSnapshot, currentEventId, 0L);
        }
        catch (Exception exception) {
            LOGGER.error("Root Exception", ExceptionUtils.getRootCause((Throwable)exception));
            if (exception instanceof TException) {
                LOGGER.error("Fetching new HMS snapshot failed because of HMS communication. HMS seems to be restarted. Will try again.");
            } else {
                LOGGER.error("Fetching new HMS snapshot failed. Will try again.");
            }
            this.close();
            return new PathsImage(Collections.emptyMap(), 0L, 0L);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Collection<String>> fetchFullUpdate() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

