/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.io.File;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class KerberosConfiguration
extends Configuration {
    private String principal;
    private String keytab;
    private boolean isInitiator;
    private static final boolean IBM_JAVA = System.getProperty("java.vendor").contains("IBM");

    private KerberosConfiguration(String principal, File keytab, boolean client) {
        this.principal = principal;
        this.keytab = keytab.getAbsolutePath();
        this.isInitiator = client;
    }

    public static Configuration createClientConfig(String principal, File keytab) {
        return new KerberosConfiguration(principal, keytab, true);
    }

    public static Configuration createServerConfig(String principal, File keytab) {
        return new KerberosConfiguration(principal, keytab, false);
    }

    private static String getKrb5LoginModuleName() {
        return IBM_JAVA ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (IBM_JAVA) {
            options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
            options.put("principal", this.principal);
            options.put("refreshKrb5Config", "true");
            options.put("credsType", "both");
        } else {
            options.put("keyTab", this.keytab);
            options.put("principal", this.principal);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", Boolean.toString(this.isInitiator));
        }
        String ticketCache = System.getenv("KRB5CCNAME");
        if (IBM_JAVA) {
            if (ticketCache != null) {
                System.setProperty("KRB5CCNAME", ticketCache);
            } else {
                ticketCache = System.getProperty("KRB5CCNAME");
            }
            if (ticketCache != null) {
                options.put("useDefaultCcache", "true");
                options.put("renewTGT", "true");
            }
        } else if (ticketCache != null) {
            options.put("ticketCache", ticketCache);
        }
        options.put("debug", "true");
        return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosConfiguration.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }
}

