/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveNotificationFetcher
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveNotificationFetcher.class);
    private final HiveConnectionFactory hmsConnectionFactory;
    private HiveMetaStoreClient hmsClient;

    public HiveNotificationFetcher(HiveConnectionFactory hmsConnectionFactory) {
        this.hmsConnectionFactory = hmsConnectionFactory;
    }

    public List<NotificationEvent> fetchNotifications(long lastEventId) throws Exception {
        return this.fetchNotifications(lastEventId, Integer.MAX_VALUE);
    }

    public List<NotificationEvent> fetchNotifications(long lastEventId, int maxEvents) throws Exception {
        NotificationEventResponse response;
        LOGGER.debug("Requesting HMS notifications since ID = {}", (Object)lastEventId);
        try {
            response = this.getHmsClient().getNextNotification(lastEventId, maxEvents, null);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        if (response != null && response.isSetEvents()) {
            LOGGER.debug("Fetched {} new HMS notification(s)", (Object)response.getEventsSize());
            return response.getEvents();
        }
        return Collections.emptyList();
    }

    private HiveMetaStoreClient getHmsClient() throws Exception {
        if (this.hmsClient == null) {
            try {
                this.hmsClient = this.hmsConnectionFactory.connect().getClient();
            }
            catch (Exception e) {
                LOGGER.error("Fail to connect to the HMS service: {}", (Object)e.getMessage());
                throw e;
            }
        }
        return this.hmsClient;
    }

    public long getCurrentNotificationId() throws Exception {
        CurrentNotificationEventId eventId;
        try {
            eventId = this.getHmsClient().getCurrentNotificationEventId();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        if (eventId != null && eventId.isSetEventId()) {
            return eventId.getEventId();
        }
        return 0L;
    }

    @Override
    public void close() {
        try {
            if (this.hmsClient != null) {
                this.hmsClient.close();
            }
        }
        finally {
            this.hmsClient = null;
        }
    }
}

