/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hive.hcatalog.messaging.HCatEventMessage;
import org.apache.hive.hcatalog.messaging.MessageDeserializer;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAddPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAlterPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAlterTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONCreateDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONCreateTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropTableMessage;
import org.apache.sentry.service.thrift.FullUpdateInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FullUpdateModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullUpdateModifier.class);

    private FullUpdateModifier() {
    }

    static void applyEvent(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        HCatEventMessage.EventType eventType = HCatEventMessage.EventType.valueOf((String)event.getEventType());
        switch (eventType) {
            case CREATE_DATABASE: {
                FullUpdateModifier.createDatabase(image, event, deserializer);
                break;
            }
            case DROP_DATABASE: {
                FullUpdateModifier.dropDatabase(image, event, deserializer);
                break;
            }
            case CREATE_TABLE: {
                FullUpdateModifier.createTable(image, event, deserializer);
                break;
            }
            case DROP_TABLE: {
                FullUpdateModifier.dropTable(image, event, deserializer);
                break;
            }
            case ALTER_TABLE: {
                FullUpdateModifier.alterTable(image, event, deserializer);
                break;
            }
            case ADD_PARTITION: {
                FullUpdateModifier.addPartition(image, event, deserializer);
                break;
            }
            case DROP_PARTITION: {
                FullUpdateModifier.dropPartition(image, event, deserializer);
                break;
            }
            case ALTER_PARTITION: {
                FullUpdateModifier.alterPartition(image, event, deserializer);
                break;
            }
            default: {
                LOGGER.error("Notification with ID:{} has invalid event type: {}", (Object)event.getEventId(), (Object)event.getEventType());
            }
        }
    }

    private static void createDatabase(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        SentryJSONCreateDatabaseMessage message = (SentryJSONCreateDatabaseMessage)deserializer.getCreateDatabaseMessage(event.getMessage());
        String dbName = message.getDB();
        if (dbName == null || dbName.isEmpty()) {
            LOGGER.error("Create database event is missing database name");
            return;
        }
        dbName = dbName.toLowerCase();
        String location = message.getLocation();
        if (location == null || location.isEmpty()) {
            LOGGER.error("Create database event is missing database location");
            return;
        }
        String path = FullUpdateInitializer.pathFromURI(location);
        if (path == null) {
            return;
        }
        if (!image.containsKey(dbName)) {
            LOGGER.debug("create database {} with location {}", (Object)dbName, (Object)location);
            image.put(dbName.intern(), Collections.singleton(path));
        } else {
            Set oldLocations = (Set)image.get(dbName);
            LOGGER.debug("database {} already exists, ignored", (Object)dbName);
            if (!oldLocations.contains(location)) {
                LOGGER.warn("database {} exists but location is different from {}", (Object)dbName, (Object)location);
            }
        }
    }

    private static void dropDatabase(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        SentryJSONDropDatabaseMessage message = (SentryJSONDropDatabaseMessage)deserializer.getDropDatabaseMessage(event.getMessage());
        String dbName = message.getDB();
        if (dbName == null || dbName.isEmpty()) {
            LOGGER.error("Drop database event is missing database name");
            return;
        }
        dbName = dbName.toLowerCase();
        String location = message.getLocation();
        if (location == null || location.isEmpty()) {
            LOGGER.error("Drop database event is missing database location");
            return;
        }
        String path = FullUpdateInitializer.pathFromURI(location);
        if (path == null) {
            return;
        }
        Set locations = (Set)image.get(dbName);
        if (locations == null) {
            LOGGER.debug("database {} is already deleted", (Object)dbName);
            return;
        }
        if (!locations.contains(path)) {
            LOGGER.warn("Database {} location does not match {}", (Object)dbName, (Object)path);
            return;
        }
        LOGGER.debug("drop database {} with location {}", (Object)dbName, (Object)location);
        image.remove(dbName);
        String dbPrefix = dbName + ".";
        Iterator<Map.Entry<String, Collection<String>>> it = image.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Collection<String>> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(dbPrefix)) continue;
            LOGGER.debug("Removing {}", (Object)key);
            it.remove();
        }
    }

    private static void createTable(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        SentryJSONCreateTableMessage message = (SentryJSONCreateTableMessage)deserializer.getCreateTableMessage(event.getMessage());
        String dbName = message.getDB();
        if (dbName == null || dbName.isEmpty()) {
            LOGGER.error("Create table event is missing database name");
            return;
        }
        String tableName = message.getTable();
        if (tableName == null || tableName.isEmpty()) {
            LOGGER.error("Create table event is missing table name");
            return;
        }
        String location = message.getLocation();
        if (location == null || location.isEmpty()) {
            LOGGER.error("Create table event is missing table location");
            return;
        }
        String path = FullUpdateInitializer.pathFromURI(location);
        if (path == null) {
            return;
        }
        String authName = dbName.toLowerCase() + "." + tableName.toLowerCase();
        if (!image.containsKey(authName)) {
            LOGGER.debug("create table {} with location {}", (Object)authName, (Object)location);
            HashSet<String> locations = new HashSet<String>(1);
            locations.add(path);
            image.put(authName.intern(), locations);
        } else {
            Set oldLocations = (Set)image.get(authName);
            LOGGER.debug("Table {} already exists, ignored", (Object)authName);
            if (!oldLocations.contains(location)) {
                LOGGER.warn("Table {} exists but location is different from {}", (Object)authName, (Object)location);
            }
        }
    }

    private static void dropTable(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        SentryJSONDropTableMessage message = (SentryJSONDropTableMessage)deserializer.getDropTableMessage(event.getMessage());
        String dbName = message.getDB();
        if (dbName == null || dbName.isEmpty()) {
            LOGGER.error("Drop table event is missing database name");
            return;
        }
        String tableName = message.getTable();
        if (tableName == null || tableName.isEmpty()) {
            LOGGER.error("Drop table event is missing table name");
            return;
        }
        String location = message.getLocation();
        if (location == null || location.isEmpty()) {
            LOGGER.error("Drop table event is missing table location");
            return;
        }
        String path = FullUpdateInitializer.pathFromURI(location);
        if (path == null) {
            return;
        }
        String authName = dbName.toLowerCase() + "." + tableName.toLowerCase();
        Set locations = (Set)image.get(authName);
        if (locations != null && locations.contains(path)) {
            LOGGER.debug("Removing {}", (Object)authName);
            image.remove(authName);
        } else {
            LOGGER.warn("can't find matching table {} with location {}", (Object)authName, (Object)location);
        }
    }

    private static void alterTable(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        Set locations;
        SentryJSONAlterTableMessage message = (SentryJSONAlterTableMessage)deserializer.getAlterTableMessage(event.getMessage());
        String prevDbName = message.getDB();
        if (prevDbName == null || prevDbName.isEmpty()) {
            LOGGER.error("Alter table event is missing old database name");
            return;
        }
        prevDbName = prevDbName.toLowerCase();
        String prevTableName = message.getTable();
        if (prevTableName == null || prevTableName.isEmpty()) {
            LOGGER.error("Alter table event is missing old table name");
            return;
        }
        prevTableName = prevTableName.toLowerCase();
        String newDbName = event.getDbName();
        if (newDbName == null || newDbName.isEmpty()) {
            LOGGER.error("Alter table event is missing new database name");
            return;
        }
        newDbName = newDbName.toLowerCase();
        String newTableName = event.getTableName();
        if (newTableName == null || newTableName.isEmpty()) {
            LOGGER.error("Alter table event is missing new table name");
            return;
        }
        newTableName = newTableName.toLowerCase();
        String prevLocation = message.getOldLocation();
        if (prevLocation == null || prevLocation.isEmpty()) {
            LOGGER.error("Alter table event is missing old location");
            return;
        }
        String prevPath = FullUpdateInitializer.pathFromURI(prevLocation);
        if (prevPath == null) {
            return;
        }
        String newLocation = message.getNewLocation();
        if (newLocation == null || newLocation.isEmpty()) {
            LOGGER.error("Alter table event is missing new location");
            return;
        }
        String newPath = FullUpdateInitializer.pathFromURI(newLocation);
        if (newPath == null) {
            return;
        }
        String prevAuthName = prevDbName + "." + prevTableName;
        String newAuthName = newDbName + "." + newTableName;
        if (!prevDbName.equals(newDbName)) {
            LOGGER.debug("Changing database name: {} -> {}", (Object)prevDbName, (Object)newDbName);
            locations = (Set)image.get(prevDbName);
            if (locations != null) {
                if (!image.containsKey(newDbName)) {
                    image.put(newDbName, locations);
                    image.remove(prevDbName);
                    String prevDbPrefix = prevDbName + ".";
                    String newDbPrefix = newDbName + ".";
                    FullUpdateModifier.renamePrefixKeys(image, prevDbPrefix, newDbPrefix);
                } else {
                    LOGGER.warn("database {} rename: found existing database {}", (Object)prevDbName, (Object)newDbName);
                }
            } else {
                LOGGER.debug("database {} not found", (Object)prevDbName);
            }
        }
        if (!prevAuthName.equals(newAuthName)) {
            locations = (Set)image.get(prevAuthName);
            if (locations != null) {
                if (!image.containsKey(newAuthName)) {
                    LOGGER.debug("rename {} -> {}", (Object)prevAuthName, (Object)newAuthName);
                    image.put(newAuthName, locations);
                    image.remove(prevAuthName);
                } else {
                    LOGGER.warn("auth {} rename: found existing object {}", (Object)prevAuthName, (Object)newAuthName);
                }
            } else {
                LOGGER.debug("auth {} not found", (Object)prevAuthName);
            }
        }
        if (!prevPath.equals(newPath)) {
            LOGGER.debug("Location change: {} -> {}", (Object)prevPath, (Object)newPath);
            locations = (Set)image.get(newAuthName);
            if (locations != null && locations.contains(prevPath) && !locations.contains(newPath)) {
                locations.remove(prevPath);
                locations.add(newPath);
            } else {
                LOGGER.warn("can not process location change for {}", (Object)newAuthName);
                LOGGER.warn("old locatio = {}, new location = {}", (Object)prevPath, (Object)newPath);
            }
        }
    }

    private static void addPartition(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        SentryJSONAddPartitionMessage message = (SentryJSONAddPartitionMessage)deserializer.getAddPartitionMessage(event.getMessage());
        String dbName = message.getDB();
        if (dbName == null || dbName.isEmpty()) {
            LOGGER.error("Add partition event is missing database name");
            return;
        }
        String tableName = message.getTable();
        if (tableName == null || tableName.isEmpty()) {
            LOGGER.error("Add partition event for {} is missing table name", (Object)dbName);
            return;
        }
        String authName = dbName.toLowerCase() + "." + tableName.toLowerCase();
        List locations = message.getLocations();
        if (locations == null || locations.isEmpty()) {
            LOGGER.error("Add partition event for {} is missing partition locations", (Object)authName);
            return;
        }
        Set oldLocations = (Set)image.get(authName);
        if (oldLocations == null) {
            LOGGER.warn("Add partition for {}: missing table locations", (Object)authName);
            return;
        }
        for (String location : locations) {
            String path = FullUpdateInitializer.pathFromURI(location);
            if (path == null) continue;
            LOGGER.debug("Adding partition {}:{}", (Object)authName, (Object)path);
            oldLocations.add(path);
        }
    }

    private static void dropPartition(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        SentryJSONDropPartitionMessage message = (SentryJSONDropPartitionMessage)deserializer.getDropPartitionMessage(event.getMessage());
        String dbName = message.getDB();
        if (dbName == null || dbName.isEmpty()) {
            LOGGER.error("Drop partition event is missing database name");
            return;
        }
        String tableName = message.getTable();
        if (tableName == null || tableName.isEmpty()) {
            LOGGER.error("Drop partition event for {} is missing table name", (Object)dbName);
            return;
        }
        String authName = dbName.toLowerCase() + "." + tableName.toLowerCase();
        List locations = message.getLocations();
        if (locations == null || locations.isEmpty()) {
            LOGGER.error("Drop partition event for {} is missing partition locations", (Object)authName);
            return;
        }
        Set oldLocations = (Set)image.get(authName);
        if (oldLocations == null) {
            LOGGER.warn("Add partition for {}: missing table locations", (Object)authName);
            return;
        }
        for (String location : locations) {
            String path = FullUpdateInitializer.pathFromURI(location);
            if (path == null) continue;
            oldLocations.remove(path);
        }
    }

    private static void alterPartition(Map<String, Collection<String>> image, NotificationEvent event, MessageDeserializer deserializer) {
        String newPath;
        String prevPath;
        SentryJSONAlterPartitionMessage message = (SentryJSONAlterPartitionMessage)deserializer.getAlterPartitionMessage(event.getMessage());
        String dbName = message.getDB();
        if (dbName == null || dbName.isEmpty()) {
            LOGGER.error("Alter partition event is missing database name");
            return;
        }
        String tableName = message.getTable();
        if (tableName == null || tableName.isEmpty()) {
            LOGGER.error("Alter partition event for {} is missing table name", (Object)dbName);
            return;
        }
        String authName = dbName.toLowerCase() + "." + tableName.toLowerCase();
        String prevLocation = message.getOldLocation();
        if (prevLocation == null || prevLocation.isEmpty()) {
            LOGGER.error("Alter partition event for {} is missing old location", (Object)authName);
        }
        if ((prevPath = FullUpdateInitializer.pathFromURI(prevLocation)) == null) {
            return;
        }
        String newLocation = message.getNewLocation();
        if (newLocation == null || newLocation.isEmpty()) {
            LOGGER.error("Alter partition event for {} is missing new location", (Object)authName);
        }
        if ((newPath = FullUpdateInitializer.pathFromURI(newLocation)) == null) {
            return;
        }
        if (prevPath.equals(newPath)) {
            LOGGER.warn("Alter partition event for {} has the same old and new path {}", (Object)authName, (Object)prevPath);
            return;
        }
        Set locations = (Set)image.get(authName);
        if (locations == null) {
            LOGGER.warn("Missing partition locations for {}", (Object)authName);
            return;
        }
        if (locations.remove(prevPath)) {
            LOGGER.debug("Renaming {} to {}", (Object)prevPath, (Object)newPath);
            locations.add(newPath);
        }
    }

    @VisibleForTesting
    protected static void renamePrefixKeys(Map<String, Collection<String>> image, String oldKey, String newKey) {
        HashMap<String, Set<String>> replacement = new HashMap<String, Set<String>>();
        Iterator<Map.Entry<String, Collection<String>>> it = image.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Collection<String>> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(oldKey)) continue;
            String updatedKey = key.replaceAll("^" + oldKey + "(.*)", newKey + "$1");
            if (!image.containsKey(updatedKey)) {
                LOGGER.debug("Rename {} to {}", (Object)key, (Object)updatedKey);
                replacement.put(updatedKey, (Set)entry.getValue());
                it.remove();
                continue;
            }
            LOGGER.warn("skipping key {} - already present", (Object)updatedKey);
        }
        FullUpdateModifier.mergeMaps(image, replacement);
    }

    private static void mergeMaps(Map<String, Collection<String>> m1, Map<String, Set<String>> m2) {
        for (Map.Entry<String, Set<String>> entry : m2.entrySet()) {
            if (m1.containsKey(entry.getKey())) continue;
            m1.put(entry.getKey(), entry.getValue());
        }
    }
}

