/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.service.persistent.SentryUpgradeOrder;

public class SentryStoreSchemaInfo {
    private static final String SQL_FILE_EXTENSION = ".sql";
    private static final String UPGRADE_FILE_PREFIX = "upgrade-";
    private static final String INIT_FILE_PREFIX = "sentry-";
    private static final String VERSION_UPGRADE_LIST = "upgrade.order";
    private final String dbType;
    private final Map<String, List<String>> sentrySchemaVersions;
    private final String sentryScriptDir;
    private static final String SENTRY_VERSION = "2.1.0";

    public SentryStoreSchemaInfo(String sentryScriptDir, String dbType) throws SentryUserException {
        this.sentryScriptDir = sentryScriptDir;
        this.dbType = dbType;
        String upgradeListFile = this.getSentryStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try {
            this.sentrySchemaVersions = SentryUpgradeOrder.readUpgradeGraph(new FileReader(upgradeListFile));
        }
        catch (FileNotFoundException e) {
            throw new SentryUserException("File " + upgradeListFile + " not found ", (Throwable)e);
        }
        catch (IOException e) {
            throw new SentryUserException("Error reading " + upgradeListFile, (Throwable)e);
        }
    }

    public String getSentrySchemaVersion() {
        return SENTRY_VERSION;
    }

    public List<String> getUpgradeScripts(String fromSchemaVer) throws SentryUserException {
        if (SentryStoreSchemaInfo.getSentryVersion().equals(fromSchemaVer)) {
            return Collections.emptyList();
        }
        List<String> upgradePathList = SentryUpgradeOrder.getUpgradePath(this.sentrySchemaVersions, fromSchemaVer, this.getSentrySchemaVersion());
        if (upgradePathList.isEmpty()) {
            throw new SentryUserException("Unknown version specified for upgrade " + fromSchemaVer + " Sentry schema may be too old or newer");
        }
        LinkedList<String> upgradeScriptList = new LinkedList<String>();
        for (String upgradePath : upgradePathList) {
            upgradeScriptList.add(this.generateUpgradeFileName(upgradePath));
        }
        return upgradeScriptList;
    }

    public String generateInitFileName(String toVersion, String scriptDir) throws SentryUserException {
        String version = toVersion;
        if (version == null) {
            version = SentryStoreSchemaInfo.getSentryVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + this.dbType + "-" + version + SQL_FILE_EXTENSION;
        if (!new File(scriptDir + File.separatorChar + initScriptName).exists()) {
            throw new SentryUserException("Unknown version specified for initialization: " + version);
        }
        return initScriptName;
    }

    public String getSentryStoreScriptDir() {
        return this.sentryScriptDir;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return "sentry-upgrade-" + this.dbType + "-" + fileVersion + SQL_FILE_EXTENSION;
    }

    public static String getSentryVersion() {
        return SENTRY_VERSION;
    }
}

