/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sentry.SentryOwnerInfo;
import org.apache.sentry.api.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryGroup;
import org.apache.sentry.api.service.thrift.TSentryMappingData;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.api.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.api.service.thrift.TSentryRole;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.provider.db.service.classification.InterfaceAudience;
import org.apache.sentry.provider.db.service.model.MSentryPathChange;
import org.apache.sentry.provider.db.service.model.MSentryPermChange;
import org.apache.sentry.provider.db.service.persistent.CounterWait;
import org.apache.sentry.provider.db.service.persistent.PermissionsImage;
import org.apache.sentry.service.common.ServiceConstants;
import sentry.com.codahale.metrics.Gauge;

@InterfaceAudience.Private
public interface SentryStoreInterface {
    public void alterSentryRoleAddGroups(String var1, String var2, Set<TSentryGroup> var3) throws Exception;

    public void alterSentryRoleAddUsers(String var1, Set<String> var2) throws Exception;

    public void alterSentryRoleDeleteGroups(String var1, Set<TSentryGroup> var2) throws Exception;

    public void alterSentryRoleDeleteUsers(String var1, Set<String> var2) throws Exception;

    public void alterSentryRoleGrantPrivileges(String var1, Set<TSentryPrivilege> var2) throws Exception;

    public void alterSentryRoleRevokePrivileges(String var1, Set<TSentryPrivilege> var2) throws Exception;

    public void createSentryRole(String var1) throws Exception;

    public void dropPrivilege(TSentryAuthorizable var1) throws Exception;

    public void dropSentryRole(String var1) throws Exception;

    public Set<String> getRoleNamesForGroups(Set<String> var1) throws Exception;

    public TSentryPrivilegeMap listSentryPrivilegesByAuthorizable(Set<String> var1, TSentryActiveRoleSet var2, TSentryAuthorizable var3, boolean var4) throws Exception;

    public TSentryPrivilegeMap listSentryPrivilegesByAuthorizableForUser(Set<String> var1, TSentryAuthorizable var2, boolean var3) throws Exception;

    public Set<TSentryPrivilege> getTSentryPrivileges(ServiceConstants.SentryPrincipalType var1, Set<String> var2, TSentryAuthorizable var3) throws Exception;

    public Set<TSentryPrivilege> getAllTSentryPrivilegesByRoleName(String var1) throws Exception;

    public Set<TSentryPrivilege> getAllTSentryPrivilegesByUserName(String var1) throws Exception;

    public Set<String> listSentryPrivilegesForProvider(Set<String> var1, Set<String> var2, TSentryActiveRoleSet var3, TSentryAuthorizable var4) throws Exception;

    public Set<TSentryPrivilege> listSentryPrivilegesByUsersAndGroups(Set<String> var1, Set<String> var2, TSentryActiveRoleSet var3, TSentryAuthorizable var4) throws Exception;

    public boolean hasAnyServerPrivileges(Set<String> var1, Set<String> var2, TSentryActiveRoleSet var3, String var4) throws Exception;

    public Set<TSentryRole> getTSentryRolesByGroupName(Set<String> var1, boolean var2) throws Exception;

    public Set<TSentryRole> getTSentryRolesByUserNames(Set<String> var1) throws Exception;

    public void renamePrivilege(TSentryAuthorizable var1, TSentryAuthorizable var2) throws Exception;

    public Map<String, Set<TSentryPrivilege>> getRoleNameTPrivilegesMap(String var1, String var2) throws Exception;

    public List<Map<String, Set<String>>> getGroupUserRoleMapList(Collection<String> var1) throws Exception;

    public void importSentryMetaData(TSentryMappingData var1, boolean var2) throws Exception;

    public void clearHmsPathInformation() throws Exception;

    public void stop();

    public void setLastProcessedNotificationID(Long var1) throws Exception;

    public boolean isNotificationProcessed(String var1) throws Exception;

    public boolean isHmsNotificationEmpty() throws Exception;

    public Long getLastProcessedNotificationID() throws Exception;

    public void persistLastProcessedNotificationID(Long var1) throws Exception;

    public void setPersistUpdateDeltas(boolean var1);

    public void purgeDeltaChangeTables();

    public void purgeNotificationIdTable();

    public CounterWait getCounterWait();

    public Gauge<Long> getRoleCountGauge();

    public Gauge<Long> getGroupCountGauge();

    public Gauge<Integer> getHMSWaitersCountGauge();

    public Gauge<Long> getPrivilegeCountGauge();

    public Gauge<Long> getGenericModelPrivilegeCountGauge();

    public Gauge<Long> getLastNotificationIdGauge();

    public Gauge<Long> getLastPathsSnapshotIdGauge();

    public Gauge<Long> getPermChangeIdGauge();

    public Gauge<Long> getPathChangeIdGauge();

    public Gauge<Long> getAuthzObjectsCountGauge();

    public Gauge<Long> getAuthzPathsCountGauge();

    public void alterSentryRoleAddGroups(String var1, String var2, Set<TSentryGroup> var3, Updateable.Update var4) throws Exception;

    public void alterSentryRoleDeleteGroups(String var1, Set<TSentryGroup> var2, Updateable.Update var3) throws Exception;

    public void alterSentryRoleGrantPrivileges(String var1, Set<TSentryPrivilege> var2, Map<TSentryPrivilege, Updateable.Update> var3) throws Exception;

    public void alterSentryRoleRevokePrivileges(String var1, Set<TSentryPrivilege> var2, Map<TSentryPrivilege, Updateable.Update> var3) throws Exception;

    public void dropPrivilege(TSentryAuthorizable var1, Updateable.Update var2) throws Exception;

    public void dropSentryRole(String var1, Updateable.Update var2) throws Exception;

    public PermissionsImage retrieveFullPermssionsImage() throws Exception;

    public PathsUpdate retrieveFullPathsImageUpdate(String[] var1) throws Exception;

    public void renamePrivilege(TSentryAuthorizable var1, TSentryAuthorizable var2, Updateable.Update var3) throws Exception;

    public List<MSentryPermChange> getMSentryPermChanges(long var1) throws Exception;

    public Boolean permChangeExists(long var1) throws Exception;

    public Long getLastProcessedPermChangeID() throws Exception;

    public List<MSentryPathChange> getMSentryPathChanges(long var1) throws Exception;

    public Boolean pathChangeExists(long var1) throws Exception;

    public Long getLastProcessedPathChangeID() throws Exception;

    public void persistFullPathsImage(Map<String, Collection<String>> var1, long var2) throws Exception;

    public void addAuthzPathsMapping(String var1, Collection<String> var2, UniquePathsUpdate var3) throws Exception;

    public void deleteAllAuthzPathsMapping(String var1, UniquePathsUpdate var2) throws Exception;

    public void deleteAuthzPathsMapping(String var1, Collection<String> var2, UniquePathsUpdate var3) throws Exception;

    public void renameAuthzObj(String var1, String var2, UniquePathsUpdate var3) throws Exception;

    public void renameAuthzPathsMapping(String var1, String var2, String var3, String var4, UniquePathsUpdate var5) throws Exception;

    public void updateAuthzPathsMapping(String var1, String var2, String var3, UniquePathsUpdate var4) throws Exception;

    public boolean isAuthzPathsSnapshotEmpty() throws Exception;

    public long getLastProcessedImageID() throws Exception;

    public void alterSentryGrantOwnerPrivilege(String var1, ServiceConstants.SentryPrincipalType var2, TSentryPrivilege var3, Updateable.Update var4) throws Exception;

    public void alterSentryRevokeOwnerPrivilege(TSentryAuthorizable var1, List<Updateable.Update> var2) throws Exception;

    public List<SentryOwnerInfo> listOwnersByAuthorizable(TSentryAuthorizable var1) throws Exception;

    public void updateOwnerPrivilege(TSentryAuthorizable var1, String var2, ServiceConstants.SentryPrincipalType var3, List<Updateable.Update> var4) throws Exception;

    public Map<String, Set<TSentryPrivilege>> getAllRolesPrivileges() throws Exception;

    public Map<String, Set<TSentryPrivilege>> getAllUsersPrivileges() throws Exception;
}

