/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.apache.sentry.service.thrift.DynamicProxy;
import org.slf4j.Logger;

public class SentryStoreFactory {
    public static SentryStoreInterface create(Configuration conf, Logger logger) {
        String sentryStoreClass = conf.get("sentry.service.sentrystore", "org.apache.sentry.provider.db.service.persistent.SentryStore");
        try {
            Class sentryClazz = conf.getClassByName(sentryStoreClass);
            Constructor sentryConstructor = sentryClazz.getConstructor(Configuration.class);
            Object sentryObj = sentryConstructor.newInstance(conf);
            if (sentryObj instanceof SentryStoreInterface) {
                logger.info("Instantiating sentry store class: " + sentryStoreClass);
                return (SentryStoreInterface)sentryConstructor.newInstance(conf);
            }
            logger.warn(String.format("Trying to use a proxy instance (duck-typing) for the supplied SentryStore, since the specified class %s does not implement SentryStoreIface.", sentryStoreClass));
            return new DynamicProxy<SentryStoreInterface>(sentryObj, SentryStoreInterface.class, sentryStoreClass).createProxy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create " + sentryStoreClass, e);
        }
    }
}

