/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.sentry.SentryOwnerInfo;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.common.Status;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryGrantOption;
import org.apache.sentry.api.service.thrift.TSentryPrincipalType;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipal;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipalType;
import org.apache.sentry.provider.db.audit.SentryAuditLogger;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.apache.sentry.service.common.ServiceConstants;

class SentryHMSOwnerHandler {
    private final SentryStoreInterface sentryStore;
    private final String AUTHZ_SERVER_NAME;
    private final SentryAuditLogger audit;
    private final String SENTRY_SERVICE_USER;
    private static final String NO_TABLE_TYPE = null;
    private static final String NO_TABLE = null;
    private static final Map<PrincipalType, TPrivilegePrincipalType> SENTRY_T_PRIVILEGE_PRINCIPAL_TYPE_MAP = ImmutableMap.of((Object)PrincipalType.ROLE, (Object)TPrivilegePrincipalType.ROLE, (Object)PrincipalType.USER, (Object)TPrivilegePrincipalType.USER);
    private static final Map<PrincipalType, TSentryPrincipalType> SENTRY_T_PRINCIPAL_TYPE_MAP = ImmutableMap.of((Object)PrincipalType.ROLE, (Object)TSentryPrincipalType.ROLE, (Object)PrincipalType.USER, (Object)TSentryPrincipalType.USER);
    private static final Map<PrincipalType, ServiceConstants.SentryPrincipalType> SENTRY_PRINCIPAL_TYPE_MAP = ImmutableMap.of((Object)PrincipalType.ROLE, (Object)ServiceConstants.SentryPrincipalType.ROLE, (Object)PrincipalType.USER, (Object)ServiceConstants.SentryPrincipalType.USER);
    private static final Map<ServiceConstants.SentryPrincipalType, PrincipalType> PRINCIPAL_TYPE_MAP = ImmutableMap.of((Object)ServiceConstants.SentryPrincipalType.ROLE, (Object)PrincipalType.ROLE, (Object)ServiceConstants.SentryPrincipalType.USER, (Object)PrincipalType.USER);

    SentryHMSOwnerHandler(SentryStoreInterface store, SentryAuditLogger audit, String authzServerName, String serviceUser) {
        this.sentryStore = store;
        this.AUTHZ_SERVER_NAME = authzServerName;
        this.audit = audit;
        this.SENTRY_SERVICE_USER = serviceUser;
    }

    void grantDatabaseOwnerPrivilege(String dbName, PrincipalType ownerType, String ownerName, boolean grantOption) throws Exception {
        if (!this.isPrincipalTypeSupported(ownerType)) {
            throw new Exception(String.format("Owner type not supported: %s", ownerType.toString()));
        }
        this.grantOwnerPrivilegeOnObject(dbName, NO_TABLE_TYPE, NO_TABLE, ownerType, ownerName, grantOption);
    }

    void grantTableOwnerPrivilege(String dbName, String tableType, String tableName, PrincipalType ownerType, String ownerName, boolean grantOption) throws Exception {
        if (!this.isPrincipalTypeSupported(ownerType)) {
            throw new Exception(String.format("Owner type not supported: %s", ownerType.toString()));
        }
        this.grantOwnerPrivilegeOnObject(dbName, tableType, tableName, ownerType, ownerName, grantOption);
    }

    void dropDatabaseOwnerPrivileges(String dbName) throws Exception {
        this.dropOwnerPrivilegesFromObject(dbName, NO_TABLE_TYPE, NO_TABLE);
    }

    void dropTableOwnerPrivileges(String dbName, String tableType, String tableName) throws Exception {
        this.dropOwnerPrivilegesFromObject(dbName, tableType, tableName);
    }

    private void dropOwnerPrivilegesFromObject(String dbName, String tableType, String tableName) throws Exception {
        String authzObj = this.toAuthzObjString(dbName, tableName);
        TSentryAuthorizable authorizable = this.toTSentryAuthorizable(dbName, tableName);
        ArrayList<Updateable.Update> permissionUpdates = null;
        if (tableName == null || !this.isVirtualView(tableType)) {
            permissionUpdates = new ArrayList<Updateable.Update>();
            List<SentryOwnerInfo> ownerInfoList = this.sentryStore.listOwnersByAuthorizable(authorizable);
            for (SentryOwnerInfo ownerInfo : ownerInfoList) {
                permissionUpdates.add(this.createDeleteOwnerPermissionUpdate(authzObj, PRINCIPAL_TYPE_MAP.get(ownerInfo.getOwnerType()), ownerInfo.getOwnerName()));
            }
        }
        this.sentryStore.alterSentryRevokeOwnerPrivilege(authorizable, permissionUpdates);
    }

    private void grantOwnerPrivilegeOnObject(String dbName, String tableType, String tableName, PrincipalType ownerType, String ownerName, boolean withGrant) throws Exception {
        TSentryPrivilege ownerPrivilege = this.createOwnerPrivilege(dbName, tableName, withGrant);
        Updateable.Update grantPermissionUpdate = null;
        if (tableName == null || !this.isVirtualView(tableType)) {
            grantPermissionUpdate = this.createAddOwnerPermissionUpdate(this.toAuthzObjString(dbName, tableName), ownerType, ownerName);
        }
        this.sentryStore.alterSentryGrantOwnerPrivilege(ownerName, SENTRY_PRINCIPAL_TYPE_MAP.get(ownerType), ownerPrivilege, grantPermissionUpdate);
        this.audit.onGrantOwnerPrivilege(Status.OK(), this.SENTRY_SERVICE_USER, SENTRY_T_PRINCIPAL_TYPE_MAP.get(ownerType), ownerName, this.toTSentryAuthorizable(dbName, tableName));
    }

    private TSentryPrivilege createOwnerPrivilege(String dbName, String tableName, boolean withGrant) {
        TSentryPrivilege ownerPrivilege = new TSentryPrivilege();
        ownerPrivilege.setAction("OWNER");
        if (tableName == null) {
            ownerPrivilege.setPrivilegeScope(ApiConstants.PrivilegeScope.DATABASE.toString());
        } else {
            ownerPrivilege.setPrivilegeScope(ApiConstants.PrivilegeScope.TABLE.toString());
        }
        ownerPrivilege.setServerName(this.AUTHZ_SERVER_NAME);
        ownerPrivilege.setDbName(dbName);
        ownerPrivilege.setTableName(tableName);
        ownerPrivilege.setGrantOption(withGrant ? TSentryGrantOption.TRUE : TSentryGrantOption.FALSE);
        return ownerPrivilege;
    }

    private boolean isPrincipalTypeSupported(PrincipalType principalType) {
        return principalType == PrincipalType.ROLE || principalType == PrincipalType.USER;
    }

    private Updateable.Update createAddOwnerPermissionUpdate(String authzObj, PrincipalType ownerType, String ownerName) {
        PermissionsUpdate update = new PermissionsUpdate();
        update.addPrivilegeUpdate(authzObj).putToAddPrivileges(new TPrivilegePrincipal(SENTRY_T_PRIVILEGE_PRINCIPAL_TYPE_MAP.get(ownerType), ownerName), "OWNER");
        return update;
    }

    private Updateable.Update createDeleteOwnerPermissionUpdate(String authzObj, PrincipalType ownerType, String ownerName) {
        PermissionsUpdate update = new PermissionsUpdate();
        update.addPrivilegeUpdate(authzObj).putToDelPrivileges(new TPrivilegePrincipal(SENTRY_T_PRIVILEGE_PRINCIPAL_TYPE_MAP.get(ownerType), ownerName), "OWNER");
        return update;
    }

    private String toAuthzObjString(String dbName, String tableName) {
        if (tableName == null) {
            return dbName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dbName).append(".").append(tableName);
        return sb.toString();
    }

    private TSentryAuthorizable toTSentryAuthorizable(String dbName, String tableName) {
        TSentryAuthorizable authorizable = new TSentryAuthorizable();
        authorizable.setServer(this.AUTHZ_SERVER_NAME);
        authorizable.setDb(dbName);
        authorizable.setTable(tableName);
        return authorizable;
    }

    private boolean isVirtualView(String tableType) {
        return !Strings.isNullOrEmpty((String)tableType) && tableType.equalsIgnoreCase(TableType.VIRTUAL_VIEW.name());
    }
}

