/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sentry.core.common.utils.SentryUtils;
import org.apache.sentry.provider.db.service.model.MSentryChange;

public final class MSentryUtil {
    static String safeIntern(String arg) {
        return arg != null ? arg.intern() : null;
    }

    private static List<Long> getChangeIds(Collection<? extends MSentryChange> changes) {
        ArrayList<Long> ids = changes.isEmpty() ? Collections.emptyList() : new ArrayList<Long>(changes.size());
        for (MSentryChange mSentryChange : changes) {
            ids.add(mSentryChange.getChangeID());
        }
        return ids;
    }

    public static boolean isConsecutive(List<? extends MSentryChange> changes) {
        int size = changes.size();
        return size <= 1 || changes.get(size - 1).getChangeID() - changes.get(0).getChangeID() + 1L == (long)size;
    }

    public static String collapseChangeIDsToString(Collection<? extends MSentryChange> changes) {
        return SentryUtils.collapseNumsToString(MSentryUtil.getChangeIds(changes));
    }
}

