/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.audit;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddUsersRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddUsersResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteUsersRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteUsersResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.api.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.api.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.api.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.api.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryPrincipalType;
import org.apache.sentry.provider.db.log.entity.JsonLogEntity;
import org.apache.sentry.provider.db.log.entity.JsonLogEntityFactory;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryAuditLogger {
    private static final Logger ERROR_LOGGER = LoggerFactory.getLogger(SentryAuditLogger.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"sentry.hive.authorization.ddl.logger");
    private static final JsonLogEntityFactory JSON_LOG_ENTITY = JsonLogEntityFactory.getInstance();
    private final Configuration conf;

    public SentryAuditLogger(Configuration conf) {
        this.conf = conf;
    }

    public void onCreateRole(TCreateSentryRoleRequest request, TCreateSentryRoleResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for creating a role: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onDropRole(TDropSentryRoleRequest request, TDropSentryRoleResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for creating a role: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onGrantRolePrivilege(TAlterSentryRoleGrantPrivilegeRequest request, TAlterSentryRoleGrantPrivilegeResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntities(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for grant role privilege: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onGrantOwnerPrivilege(TSentryResponseStatus status, String requestorUserName, TSentryPrincipalType ownerType, String ownerName, TSentryAuthorizable authorizable) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity("GRANT_OWNER_PRIVILEGE", "PRINCIPAL", requestorUserName, status, authorizable, ownerType, ownerName, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for grant owner privilege: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onTransferOwnerPrivilege(TSentryResponseStatus status, String requestorUserName, TSentryPrincipalType ownerType, String ownerName, TSentryAuthorizable authorizable) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity("TRANSFER_OWNER_PRIVILEGE", "PRINCIPAL", requestorUserName, status, authorizable, ownerType, ownerName, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for grant owner privilege: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onRevokeRolePrivilege(TAlterSentryRoleRevokePrivilegeRequest request, TAlterSentryRoleRevokePrivilegeResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntities(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for revoke role privilege: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onRevokeUserOwnerPrivilege(String requestorUserName, TSentryResponseStatus status, String userName, TSentryAuthorizable authorizable) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity("REVOKE_PRIVILEGE", "PRINCIPAL", requestorUserName, status, authorizable, TSentryPrincipalType.USER, userName, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for grant user owner privilege: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onGrantRoleToGroup(TAlterSentryRoleAddGroupsRequest request, TAlterSentryRoleAddGroupsResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for adding groups to a role: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onRevokeRoleFromGroup(TAlterSentryRoleDeleteGroupsRequest request, TAlterSentryRoleDeleteGroupsResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for deleting groups from a role: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onGrantRoleToUser(TAlterSentryRoleAddUsersRequest request, TAlterSentryRoleAddUsersResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for adding users to a role: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    public void onRevokeRoleFromUser(TAlterSentryRoleDeleteUsersRequest request, TAlterSentryRoleDeleteUsersResponse response) {
        try {
            this.info(JSON_LOG_ENTITY.createJsonLogEntity(request, response, this.conf));
        }
        catch (Exception e) {
            String msg = "Cannot generate an audit log for deleting users from a role: " + e.getMessage();
            ERROR_LOGGER.error(msg, (Throwable)e);
        }
    }

    private void info(Collection<JsonLogEntity> jsonLogEntities) throws Exception {
        for (JsonLogEntity jsonLogEntity : jsonLogEntities) {
            this.info(jsonLogEntity);
        }
    }

    private void info(JsonLogEntity jsonLogEntity) throws Exception {
        AUDIT_LOGGER.info(jsonLogEntity.toJsonFormatLog());
    }
}

