/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.service.thrift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.service.thrift.RolesServlet;
import org.apache.sentry.api.service.thrift.SentryHealthCheckServletContextListener;
import org.apache.sentry.api.service.thrift.SentryMetricsServletContextListener;
import org.apache.sentry.server.provider.webservice.ServletDesc;
import org.apache.sentry.server.provider.webservice.WebServiceProvider;
import org.apache.sentry.server.provider.webservice.WebServiceProviderFactory;
import org.eclipse.jetty.servlet.ServletHolder;
import sentry.com.codahale.metrics.servlets.HealthCheckServlet;
import sentry.com.codahale.metrics.servlets.MetricsServlet;
import sentry.com.codahale.metrics.servlets.PingServlet;
import sentry.com.codahale.metrics.servlets.ThreadDumpServlet;

public class SentryServiceWebServiceProvider
implements WebServiceProvider,
WebServiceProviderFactory {
    public static final String ID = "sentry-admin";
    private Configuration config;

    public List<EventListener> getListeners() {
        return Arrays.asList(new SentryHealthCheckServletContextListener(), new SentryMetricsServletContextListener());
    }

    public List<ServletDesc> getServlets() {
        ArrayList<ServletDesc> servlets = new ArrayList<ServletDesc>();
        servlets.add(ServletDesc.of((String)"/metrics", (ServletHolder)new ServletHolder(MetricsServlet.class)));
        servlets.add(ServletDesc.of((String)"/threads", (ServletHolder)new ServletHolder(ThreadDumpServlet.class)));
        servlets.add(ServletDesc.of((String)"/healthcheck", (ServletHolder)new ServletHolder(HealthCheckServlet.class)));
        servlets.add(ServletDesc.of((String)"/ping", (ServletHolder)new ServletHolder(PingServlet.class)));
        if (this.config.getBoolean("sentry.web.admin.servlet.enabled", false)) {
            servlets.add(ServletDesc.of((String)"/admin/showAll", (ServletHolder)new ServletHolder(RolesServlet.class)));
            servlets.add(ServletDesc.of((String)"/admin/roles", (ServletHolder)new ServletHolder(RolesServlet.class)));
        }
        return servlets;
    }

    public void init(Configuration config) {
        this.config = config;
    }

    public WebServiceProvider create() {
        return this;
    }

    public String getId() {
        return ID;
    }

    public void close() {
    }
}

