/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.service.thrift;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.persistent.SentryStore;

public class RolesServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("sentry.conf");
        assert (conf != null);
        PrintWriter out = response.getWriter();
        try {
            SentryStore sentrystore = new SentryStore(conf);
            HashMap<String, Set<TSentryPrivilege>> roleMap = new HashMap<String, Set<TSentryPrivilege>>();
            Set<String> roleSet = sentrystore.getAllRoleNames();
            for (String roleName : roleSet) {
                roleMap.put(roleName, sentrystore.getAllTSentryPrivilegesByRoleName(roleName));
            }
            String json = new Gson().toJson(roleMap);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            ((Writer)out).write(json);
        }
        catch (Exception e) {
            response.sendError(400, e.getMessage());
        }
        ((Writer)out).close();
    }
}

