/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.runtime;

import co.cask.tephra.persist.NoOpTransactionStateStorage;
import co.cask.tephra.persist.TransactionStateStorage;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.hadoop.conf.Configuration;

@Singleton
public final class TransactionStateStorageProvider
implements Provider<TransactionStateStorage> {
    private final Configuration cConf;
    private final Injector injector;

    @Inject
    TransactionStateStorageProvider(Configuration cConf, Injector injector) {
        this.cConf = cConf;
        this.injector = injector;
    }

    public TransactionStateStorage get() {
        if (this.cConf.getBoolean("tx.persist", true)) {
            return (TransactionStateStorage)this.injector.getInstance(Key.get(TransactionStateStorage.class, (Annotation)Names.named((String)"persist")));
        }
        return (TransactionStateStorage)this.injector.getInstance(NoOpTransactionStateStorage.class);
    }
}

