/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.sentry.hdfs.PathsUpdate;

public class UniquePathsUpdate
extends PathsUpdate {
    private final String eventHash;

    public UniquePathsUpdate(NotificationEvent event, boolean hasFullImage) {
        super(event.getEventId(), hasFullImage);
        this.eventHash = UniquePathsUpdate.sha1(event);
    }

    public UniquePathsUpdate(String eventHash, long eventId, boolean hasFullImage) {
        super(eventId, hasFullImage);
        this.eventHash = eventHash;
    }

    public String getEventHash() {
        return this.eventHash;
    }

    public static String sha1(NotificationEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append(event.getEventId());
        sb.append(event.getEventTime());
        sb.append(event.getEventType());
        sb.append(event.getDbName());
        sb.append(event.getTableName());
        sb.append(event.getMessage());
        return DigestUtils.shaHex((String)sb.toString());
    }
}

