/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;

public class ThriftSerializer {
    private static final TJSONProtocol.Factory tJSONProtocol = new TJSONProtocol.Factory();
    @VisibleForTesting
    static long maxMessageSize = 0x6400000L;

    public static byte[] serialize(TBase baseObject) throws IOException {
        TSerializer serializer = new TSerializer(new TCompactProtocol.Factory(maxMessageSize, maxMessageSize));
        try {
            return serializer.serialize(baseObject);
        }
        catch (TException e) {
            throw new IOException("Error serializing thrift object " + baseObject, e);
        }
    }

    public static TBase deserialize(TBase baseObject, byte[] serialized) throws IOException {
        TDeserializer deserializer = new TDeserializer(new TCompactProtocol.Factory(maxMessageSize, maxMessageSize));
        try {
            deserializer.deserialize(baseObject, serialized);
        }
        catch (TException e) {
            throw new IOException("Error deserializing thrift object " + baseObject, e);
        }
        return baseObject;
    }

    private ThriftSerializer() {
    }

    public static String serializeToJSON(TBase base) throws TException {
        TSerializer tSerializer = new TSerializer(tJSONProtocol);
        return tSerializer.toString(base);
    }

    public static void deserializeFromJSON(TBase base, String dataInJson) throws TException {
        TDeserializer tDeserializer = new TDeserializer(tJSONProtocol);
        tDeserializer.fromString(base, dataInJson);
    }
}

